/***************************************************************/
//
//
//		DirectX	[ light.cpp ]
//
//											Author	kazuki tanaka
//											Date	2017 1/25
/*---------------------------------------------------------------
Update : 2017/1/25
			light.cpp̍쐬

/*---------------------------------------------------------------
	CN[ht@C
---------------------------------------------------------------*/

//#include <Windows.h>
//#include <stdio.h>
//#include <d3dx9.h>

#include "light.h"

//#pragma comment (lib,"d3d9.lib")
//#pragma comment (lib,"d3dx9.lib")
//#pragma comment (lib,"dxguid.lib")

/*---------------------------------------------------------------
	}N`
---------------------------------------------------------------*/

/*----------------------------------------------------------------
	X^eBbNoϐ̏
----------------------------------------------------------------*/

CLight* CLight::light[ LIGHT_MAX ] = {};
LPDIRECT3DDEVICE9 CLight::pDevice = nullptr;


// LIGHT̏
CLight::CLight( )
{

	// oϐ̏
	//ZeroMemory( &name, sizeof( char*MAX_LIGHTNAME ) );

	// 
	for( int index = 0; index < LIGHT_MAX; index++ ){
		
		if( light[ index ] == NULL ){
			
			light[ index ] = this;
			lightIndex     = index;
			break;
		}
	}

}

// LIGHT̏
CLight::~CLight( )
{
	
	// Ȃ
	
}

// LIGHT̍쐬
CLight* CLight::Create( const char* LIGHT_NAME )
{


	// foCX̎擾
	if( !pDevice ){
	
		pDevice = GetDevice( );
	}
	
	// IuWFNg̍쐬
	CLight* pObject;
	pObject = new CLight;
	
	// CgɖOݒ
	strcpy( pObject->name, LIGHT_NAME );
	D3DLIGHT9 setLight;
	
	// Cg̏
	ZeroMemory( &setLight, sizeof( D3DLIGHT9 ) );

	{ // fBNViCg̍쐬

		setLight.Type    = D3DLIGHT_DIRECTIONAL;
		setLight.Diffuse = D3DXCOLOR( 0.6f, 0.4f, 0.4f, 1.0f );
		setLight.Ambient = D3DXCOLOR( 0.6f, 0.4f, 0.4f, 1.0f );
		D3DXVECTOR3 vecDir( 1.0f, -1.0f, 1.0f );
	
		// ϊxNg̒Pʍs
		D3DXVec3Normalize( (D3DXVECTOR3*)&setLight.Direction, &vecDir );
	
		// foCXւ̃Cg̐ݒ
		pDevice ->SetLight( 
			pObject->lightIndex,				// CgCfbNX( 쐬Cg̔ԍ )
			&setLight );

		// Cggp邩ǂ
		pDevice ->LightEnable( pObject->lightIndex, true );

		// CeBOsǂ
		pDevice ->SetRenderState( D3DRS_LIGHTING, true );


	} // LIGHT SET -> END

	return pObject;


}

// LIGHT̍쐬
CLight* CLight::Create( const char* LIGHT_NAME, const D3DLIGHTTYPE  lightType, const D3DCOLORVALUE Diffuse, const D3DCOLORVALUE Specular, const D3DCOLORVALUE Ambient, const D3DVECTOR Position, const D3DVECTOR Direction, const float Range, const float Falloff, const float Attenuation0, const float Attenuation1, const float Attenuation2, const float Theta, const float Phi )
{

	// foCX̎擾
	if( !pDevice ){
	
		pDevice = GetDevice( );
	}
	
	// IuWFNg̍쐬
	CLight* pObject;
	pObject = new CLight;
	
	// CgɖOݒ
	strcpy( pObject->name, LIGHT_NAME );
	D3DLIGHT9 setLight;
	
	// Cg̏
	ZeroMemory( &setLight, sizeof( D3DLIGHT9 ) );

	{ // Cg̍쐬

		setLight.Type     = lightType;
		setLight.Diffuse  = Diffuse;
		setLight.Specular = Specular;
		setLight.Ambient  = Ambient;
		setLight.Position = Position;
		setLight.Direction= Direction;
		setLight.Range    = Range;
		setLight.Falloff  = Falloff;
		setLight.Attenuation0 = Attenuation0;
		setLight.Attenuation1 = Attenuation1;
		setLight.Attenuation2 = Attenuation2;
		setLight.Theta    = Theta;
		setLight.Phi      = Phi;

	
		// ϊxNg̒Pʍs
		D3DXVec3Normalize( (D3DXVECTOR3*)&setLight.Direction, (D3DXVECTOR3*)&setLight.Direction );
	
		// foCXւ̃Cg̐ݒ
		pDevice ->SetLight( 
			pObject->lightIndex,				// CgCfbNX( 쐬Cg̔ԍ )
			&setLight );

		// Cggp邩ǂ
		pDevice ->LightEnable( pObject->lightIndex, true );

		// CeBOsǂ
		pDevice ->SetRenderState( D3DRS_LIGHTING, true );


	} // LIGHT SET -> END

	return pObject;


}

// 
void CLight::ReleaseAll( void )
{

	for( int index = 0; index < LIGHT_MAX; index++ ){

		if( light[ index ] ){
		
			SAFE_DELETE( light[index] )
		}
	}
}

// CeBOݒON
inline void CLight::LightOn( const D3DRENDERSTATETYPE type )
{

	pDevice ->SetRenderState( type, true );

}

// CeBOݒOFF
inline void CLight::LightOff( const D3DRENDERSTATETYPE type )
{

	pDevice ->SetRenderState( type, false );

}

// ݒ肵Cg擾
CLight* CLight::GetLight( const char* LIGHT_NAME )
{

	// ff[^擾ăoCh
	for( int index = 0; index < LIGHT_MAX; index++ ){
		
		if( strcmp( light[index]->name, LIGHT_NAME ) == 0 ){
			
			return light[index];
		}
	}
	return 0;
}

// ݒ肵Cg擾
CLight* CLight::GetLight( const int index )
{

	return light[index];

}

// ݒ
void CLight::SetLight( const D3DLIGHTTYPE  lightType, const D3DCOLORVALUE Diffuse, const D3DCOLORVALUE Specular, const D3DCOLORVALUE Ambient, const D3DVECTOR Position, const D3DVECTOR Direction, const float Range, const float Falloff, const float Attenuation0, const float Attenuation1, const float Attenuation2, const float Theta, const float Phi )
{

	D3DLIGHT9 setLight;
	
	// Cg̏
	//ZeroMemory( &setLight, sizeof( D3DLIGHT9 ) );

	// Cg̍쐬
	setLight.Type     = lightType;
	setLight.Diffuse  = Diffuse;
	setLight.Specular = Specular;
	setLight.Ambient  = Ambient;
	setLight.Position = Position;
	setLight.Direction= Direction;
	setLight.Range    = Range;
	setLight.Falloff  = Falloff;
	setLight.Attenuation0 = Attenuation0;
	setLight.Attenuation1 = Attenuation1;
	setLight.Attenuation2 = Attenuation2;
	setLight.Theta    = Theta;
	setLight.Phi      = Phi;

	
	// ϊxNg̒Pʍs
	D3DXVec3Normalize( (D3DXVECTOR3*)&setLight.Direction, (D3DXVECTOR3*)&setLight.Direction );
	
	// foCXւ̃Cg̐ݒ
	pDevice ->SetLight( 
		lightIndex,				// CgCfbNX( 쐬Cg̔ԍ )
		&setLight );


}



