/***************************************************************/
//
//
//		DirectX	[ light.h ]
//
//											Author	kazuki tanaka
//											Date	2017 1/25
/*---------------------------------------------------------------
Update : 2017/1/25
			light.h̍쐬


Update : 2016/1/25



/*-------------------------------------------------------------*/
#ifndef _LIGHT_H_

#define _LIGHT_H_


#include "rendererdx9.h"

/*---------------------------------------------------------------
	}N`
---------------------------------------------------------------*/

#define LIGHT_MAX     (4)
#define MAX_LIGHTNAME (16)

/*---------------------------------------------------------------
	class
---------------------------------------------------------------*/

// ݒ肷NX
class CLight
{
public:
		
	CLight( );												// RXgN^
	~CLight( );												// fXgN^
	
	static CLight* Create( const char* LIGHT_NAME );		// NX쐬


	static CLight* Create( 									// NX쐬
		const char*         LIGHT_NAME,
		const D3DLIGHTTYPE  lightType,
	    const D3DCOLORVALUE Diffuse,
	    const D3DCOLORVALUE Specular,
	    const D3DCOLORVALUE Ambient,
		const D3DVECTOR     Position,
	    const D3DVECTOR     Direction,
	    const float         Range,
	    const float         Falloff,
	    const float         Attenuation0,
	    const float         Attenuation1,
	    const float         Attenuation2,
	    const float         Theta,
	    const float         Phi );
	
	static void ReleaseAll( void );							// 
	
	
	static inline void LightOn( 
		const D3DRENDERSTATETYPE type );					// CeBOݒON
	static inline void LightOff( 
		const D3DRENDERSTATETYPE type );					// CeBOݒOFF
	
	
	static CLight* GetLight( const char* LIGHT_NAME );		// Light̃|C^擾
	static CLight* GetLight( const int index );				// Light̃|C^擾

	void SetLight(											// Lightݒ
		const D3DLIGHTTYPE  lightType,
	    const D3DCOLORVALUE Diffuse,
	    const D3DCOLORVALUE Specular,
	    const D3DCOLORVALUE Ambient,
		const D3DVECTOR     Position,
	    const D3DVECTOR     Direction,
	    const float         Range,
	    const float         Falloff,
	    const float         Attenuation0,
	    const float         Attenuation1,
	    const float         Attenuation2,
	    const float         Theta,
	    const float         Phi );
	/*
	void SetPosition( const LPD3DXVECTOR3 pos );			// |WVݒ
	*/
	
	
private:
	
	char      name[MAX_LIGHTNAME];
	int       lightIndex;

	static CLight* light[ LIGHT_MAX ];
	static LPDIRECT3DDEVICE9 pDevice;
	
};



#endif	//	_LIGHT_H_


