/***************************************************************/
//
//
//		DirectX	[ mathematics.h ]
//
//											Author	kazuki tanaka
//											Date	2017 6/9
/*---------------------------------------------------------------
Update : 2017/6/9
			Create Header File -> mathematics.h.h 
 			< Add Class Function >
				MATHEMATICS->Constructor
				MATHEMATICS->Destructor
				MATHEMATICS->Create ( static member )
				MATHEMATICS->Init
				MATHEMATICS->Uninit
				MATHEMATICS->Update
				MATHEMATICS->Draw

Update : 2017/6/9



/*-------------------------------------------------------------*/
#ifndef _MATHEMATICS_H_

#define _MATHEMATICS_H_

/*---------------------------------------------------------------
	IncludeFile + define
---------------------------------------------------------------*/

#include <math.h>
#include "vector2.h"
#include "vector3.h"
#include "matrix.h"
#include "quaternion.h"

#define _PI    ((float)  3.141592654f)
#define _1BYPI ((float)  0.318309886f)

#define LimitMax(a,b) ( a>b ? b : a )				// ől̐ݒ( ႢlԂ )
#define LimitMim(a,b) ( a>b ? a : b )				// ŏl̐ݒ( lԂ )

/*---------------------------------------------------------------
	namespace Mathematics
---------------------------------------------------------------*/

// AtBϊ
#define AFFINE_TRANSFORM_X( radiusX, radiusY, theta ) \
(( radiusX ) * cosf( RADIAN( theta )) - ( radiusY ) * sinf( RADIAN( theta )))

#define AFFINE_TRANSFORM_Y( radiusX, radiusY, theta ) \
(( radiusX ) * sinf( RADIAN( theta )) + ( radiusY ) * cosf( RADIAN( theta )))


// Class Mathematics Using Mathematics
namespace Mathematics
{

	// Factorial <K>
	int Factorial( int index );

	// Power <ݏ>
	float Power( float value, int index );

	// degree to radian
	float ToRadian( float degree );

	// radian to degree
	float ToDegree( float radian );
	
	// BernsteinBasis <o[V^C֐>
	float BernsteinBasis( int j, int h, float t );
	
	// BezieCurve <xWGȐ>
	float BezieCurve( float q0, float q1, float q2, float q3, float t );

	// HermiteCurve <G~[gȐ>
	float HermiteCurve( float t, float sx, float ex, float sv, float ev );

	// AffineTransform <AtBϊ>
	Vector2& AffineTransform( Vector2& a, Vector2& b, float radian );
	Vector2& AffineTransformDegree( Vector2& a, Vector2& b, float degree );

	// SphericalCoordinateTransform <ʍWϊ>
	Vector3& SphericalCoordinateTransform( float theta, float phy, float r );


};


#endif	//	_MATHEMATICS_H_


