/***************************************************************/
//
//
//		DirectX	[ matrix.h ]
//
//											Author	kazuki tanaka
//											Date	2017 5/15
/*---------------------------------------------------------------
Update : 2017/5/15
			Create Header File -> matrix.h.h 
 			< Add Class Function >
				MaTRIX->constructor
				MaTRIX->Destructor
				MaTRIX->Create ( static member )
				MaTRIX->Init
				MaTRIX->Uninit
				MaTRIX->Update
				MaTRIX->Draw

Update : 2017/5/15



/*-------------------------------------------------------------*/
#ifndef _MATRIX_H_

#define _MATRIX_H_

/*---------------------------------------------------------------
	Include File
---------------------------------------------------------------*/

#include "vector3.h"

/*---------------------------------------------------------------
	Class
---------------------------------------------------------------*/


// Class Matrix Using Matrix
class Matrix
{
public:
	
	// Member Function
    union {
        struct {
            float _11, _12, _13, _14;
            float _21, _22, _23, _24;
            float _31, _32, _33, _34;
            float _41, _42, _43, _44;
        };
        float mtx[4][4];
    };
	
public:
	
	Matrix();						// Matrix constructor
	~Matrix(){ };					// Matrix destructor
	Matrix( const float& );
    Matrix( const Matrix& );

    Matrix( float _11, float _12, float _13, float _14,
                float _21, float _22, float _23, float _24,
                float _31, float _32, float _33, float _34,
                float _41, float _42, float _43, float _44 );

	#ifdef __D3DX9_H__
	Matrix( const D3DXMATRIX& );
	#endif //___D3DX9_H__

	// Member Method
	Matrix& ZeroFill( void );
	Matrix& Identity( void );
	Matrix& Transpose( void );
	Matrix& Inverse( void );
	Matrix& Transform( const Vector3& trans );
	Matrix& Rotate( const Vector3& rot );
	Matrix& Scaling( const Vector3& scale );
	float Trace( void );
	float Det( void );

    // access grants
    float& operator () ( unsigned int row, unsigned int col );
    float  operator () ( unsigned int row, unsigned int col ) const;

    // casting operators
    operator float* ();
    operator const float* () const;
	#ifdef __D3DX9_H__
	operator D3DXMATRIX ();
	#endif //___D3DX9_H__

    // assignment operators
    Matrix& operator *= ( const Matrix& );
    Matrix& operator += ( const Matrix& );
    Matrix& operator -= ( const Matrix& );
    Matrix& operator *= ( float );
    Matrix& operator /= ( float );

    // unary operators
    Matrix operator + () const;
    Matrix operator - () const;

    // binary operators
    Matrix operator * ( const Matrix& ) const;
	#ifdef __D3DX9_H__
	Matrix operator * ( const D3DXMATRIX& ) const;
	#endif //___D3DX9_H__
    Matrix operator + ( const Matrix& ) const;
    Matrix operator - ( const Matrix& ) const;
    Matrix operator * ( float ) const;
    Matrix operator / ( float ) const;

    //friend Matrix operator * ( float, const Matrix& );

    bool operator == ( const Matrix& ) const;
    bool operator != ( const Matrix& ) const;

};


#endif	//	_MATRIX_H_


