/***************************************************************/
//
//
//		DirectX	[ meshrendererex.h ]
//
//											Author	kazuki tanaka
//											Date	2017 5/22
/*---------------------------------------------------------------
Update : 2017/5/22
			Create Header File -> meshrendererex.h.h 
 			< Add Class Function >
				MESHRENDEREREX->Constructor
				MESHRENDEREREX->Destructor
				MESHRENDEREREX->Create ( static member )
				MESHRENDEREREX->Init
				MESHRENDEREREX->Uninit
				MESHRENDEREREX->Update
				MESHRENDEREREX->Draw

Update : 2017/5/22



/*-------------------------------------------------------------*/
#ifndef _MESHRENDEREREX_H_

#define _MESHRENDEREREX_H_

/*--------------------------------------------------------------
	Include File
---------------------------------------------------------------*/

#include "render_interface.h"

class VertexBuffer;
class IndexBuffer;
class TextureInterface;
class Matrix;

/*--------------------------------------------------------------
	Class
---------------------------------------------------------------*/


// Class MeshRendererEX Using MeshRendererEX
class MeshRendererEX : public RenderInterface
{
public:
	
	MeshRendererEX(								// MeshRendererEX constructor
		VertexBuffer** ppVtxBuf,
		IndexBuffer** ppIdxBuf,
		TextureInterface** ppTexture,
		Matrix* pMtx );
	~MeshRendererEX( );							// MeshRendererEX destructor

	static MeshRendererEX* SetComponent( 		// MeshRendererEX Create Instance Class
		VertexBuffer** ppVtxBuf,
		IndexBuffer** ppIdxBuf,
		TextureInterface** ppTexture,
		Matrix* pMtx );	

	void Render( void );						// MeshRendererEX Draw


private:

	// Member Variable
	VertexBuffer** ppVtxBuf;
	IndexBuffer**  ppIdxBuf;
	TextureInterface** ppTexture;
	Matrix* pMtx;

};


#endif	//	_MESHRENDEREREX_H_


