/***************************************************************/
//
//
//		DirectX	[ meshrendererlist.cpp ]
//
//											Author	kazuki tanaka
//											Date	2017 6/20
/*---------------------------------------------------------------
Update : 2017/6/20
			meshrendererlist.cpp̍쐬

/*---------------------------------------------------------------
	Include File
---------------------------------------------------------------*/

#include "mesh_rendererlist.h"

#include "texture_interface.h"
#include "vertexbuffer.h"
#include "matrix.h"

#include "rendering_order.h"
#include "rendering_order_manager.h"

/*---------------------------------------------------------------
	Macro Difinition
---------------------------------------------------------------*/


/*---------------------------------------------------------------
	Const Number Difinition
---------------------------------------------------------------*/


/*----------------------------------------------------------------
	static member variable Initialize 
----------------------------------------------------------------*/





// MeshRendererList Constructor
MeshRendererList::MeshRendererList( VertexBuffer** ppVtxBuf, TextureInterface** ppTexture, Matrix* pMtx )
	: RenderInterface(3)
	, ppVtxBuf( ppVtxBuf )
	, ppTexture( ppTexture )
	, pMtx( pMtx )
{

	// Member Clear Process
	

}

// MeshRendererList Destructor
MeshRendererList::~MeshRendererList( )
{

	// Do Nothing!!

}

// MeshRendererList Create Instance 
MeshRendererList* MeshRendererList::SetComponent( VertexBuffer** ppVtxBuf, TextureInterface** ppTexture, Matrix* pMtx = nullptr )
{

	// Create Class Instance
	return new MeshRendererList( ppVtxBuf, ppTexture, pMtx );

}

// MeshRendererList Render
void MeshRendererList::Render( void )
{

	// Render Process	
	RenderingOrderManager::Operate( )->DrawPrimitiveList( *ppVtxBuf, *ppTexture, pMtx );

}

