/***************************************************************/
//
//
//		DirectX	[ meshrenderersprite.h ]
//
//											Author	kazuki tanaka
//											Date	2017 6/15
/*---------------------------------------------------------------
Update : 2017/6/15
			Create Header File -> meshrenderersprite.h.h 
 			< Add Class Function >
				MeshRendererSprite->Constructor
				MeshRendererSprite->Destructor
				MeshRendererSprite->Create ( static member )
				MeshRendererSprite->Init
				MeshRendererSprite->Uninit
				MeshRendererSprite->Update
				MeshRendererSprite->Draw

Update : 2017/6/15



/*-------------------------------------------------------------*/
#ifndef _MESHRENDERERSPRITE_H_

#define _MESHRENDERERSPRITE_H_


/*---------------------------------------------------------------
	Include File
---------------------------------------------------------------*/

#include "sprite_interface.h"

class VertexBuffer;
class TextureInterface;

/*---------------------------------------------------------------
	Class
---------------------------------------------------------------*/


// Class MeshRendererSprite Using MeshRendererSprite
class MeshRendererSprite : public SpriteInterface
{
public:
	
	MeshRendererSprite(							// MeshRendererSprite Constructor
		VertexBuffer** pVtxBuf,
		TextureInterface** pTexture,
		const int priority = 3);	
	~MeshRendererSprite( );						// MeshRendererSprite Destructor

	static MeshRendererSprite* SetComponent( 	// MeshRendererSprite Create Instance Class
		VertexBuffer** pVtxBuf,
		TextureInterface** pTexture,
		const int priority = 3);
	
	void Render( void );						// MeshRendererSprite Render Sprite


private:

	// Member Variable
	VertexBuffer**     pVtxBuf;
	TextureInterface** pTexture;

};


#endif	//	_MESHRENDERERSPRITE_H_


