/***************************************************************/
//
//
//		DirectX	[ meshcylinder.cpp ]
//
//											Author	kazuki tanaka
//											Date	2017 6/19
/*---------------------------------------------------------------
Update : 2017/6/19
			meshcylinder.cpp̍쐬

/*---------------------------------------------------------------
	Include File
---------------------------------------------------------------*/


#include "meshcylinder.h"

#include "system_component.h"

#include "mesh_renderercurringoff.h"

#include "gameobject_manager.h"

#include "vertexbuffer_manager.h"
#include "texture_manager.h"

#include "mathematics.h"


/*---------------------------------------------------------------
	Macro Difinition
---------------------------------------------------------------*/


/*----------------------------------------------------------------
	static member variable Initialize 
----------------------------------------------------------------*/





// MeshCylinder Constructor
MeshCylinder::MeshCylinder( const std::string& filename )
	: pVtxBuf(nullptr)
	, pTexture(nullptr)
	, renderer(nullptr)
	, color(1,1,1,1)
	, grid(50)
	, radius(1)
	, height(1)
{

	// Menber Clear Process
	pTexture = TextureManager::LoadFromManager( filename.data() );
	
}

// MeshCylinder Destructor
MeshCylinder::~MeshCylinder( )
{

	// Do Nothing!!

}

// MeshCylinder Create Instance 
MeshCylinder* MeshCylinder::Create( const std::string& filename )
{

	// Create Class Instance
	MeshCylinder* pObject;
	pObject = new MeshCylinder( filename.data() );

	return pObject;

}

// MeshCylinder Initialize
void MeshCylinder::Init( void )
{

	// Initialize Process
	world.Identity(); 

	pVtxBuf = VertexBufferManager::PlatformSelect();
	if( !pVtxBuf->CreateVertexBuffer( FVF_VERTEX_3D, grid*2 ) ) return;

	// Set Buffer < Vertex & Index >
	SetBuffer( );

	// Component Set
	renderer = MeshRendererCullingOff::SetComponent( &pVtxBuf, &pTexture, &world );


}

// MeshCylinder Uninitialize
void MeshCylinder::Uninit( void )
{

	// Uninitialize Process
	pVtxBuf->Release();
	RenderInterfaceManager::Delete( renderer );
	GameObjectManager::Release(this);

}

// MeshCylinder Update
void MeshCylinder::Update( void )
{

	// Update Process
	world.Identity();

}

// MeshCylinder SetBuffer
void MeshCylinder::SetBuffer( void )
{

	// Vertual Pointer
	Vertex3D*       pVtx;

	{ // _obt@̐ݒ

		pVtxBuf->Lock( &pVtx );

	    for( DWORD i=0; i<grid; i++ )
	    {
	        float theta = (2*_PI*i)/(grid-1) + (float)(_PI/2.f);

	        pVtx[2*i+0].pos      = Vector3( radius*sinf(theta),-height, radius*cosf(theta) );
	        pVtx[2*i+0].color    = 0xffffffff;
	        pVtx[2*i+0].tex      = Vector2(((float)i)/((float)grid-1.f),1.0f);
	        pVtx[2*i+0].nor      = Vector3( 1.0f, -1.0f, 1.0f ); 
			
	        pVtx[2*i+1].pos      = Vector3( radius*sinf(theta), height, radius*cosf(theta) );
	        pVtx[2*i+1].color    = 0xffffffff;
	        pVtx[2*i+1].tex      = Vector2(((float)i)/((float)grid-1.f),0.0f);
	        pVtx[2*i+1].nor      = Vector3( 1.0f, 1.0f, 1.0f ); 
	    }

		pVtxBuf->Unlock( );

	} // -> END

}

// MeshCylinder Resize
void MeshCylinder::Resize( const int grid, const float radius, const float height )
{

	MeshCylinder::grid   = grid;
	MeshCylinder::radius = radius;
	MeshCylinder::height = height;

	SetBuffer();

}

// MeshCylinder Lock
void MeshCylinder::Lock( Vertex3D* pVtx )
{

	pVtxBuf->Lock( &pVtx );

}

// MeshCylinder Unlock
void MeshCylinder::Unlock( void )
{

	pVtxBuf->Unlock( );

}





