/***************************************************************/
//
//
//		DirectX	[ meshcylinder.h ]
//
//											Author	kazuki tanaka
//											Date	2017 6/19
/*---------------------------------------------------------------
Update : 2017/6/19
			Create Header File -> meshcylinder.h.h 
 			< Add Class Function >
				MeshCylinder->Constructor
				MeshCylinder->Destructor
				MeshCylinder->Create ( static member )
				MeshCylinder->Init
				MeshCylinder->Uninit
				MeshCylinder->Update
				MeshCylinder->Draw

Update : 2017/6/19



/*-------------------------------------------------------------*/
#ifndef _MESHCYLINDER_H_

#define _MESHCYLINDER_H_


/*---------------------------------------------------------------
	Include File
---------------------------------------------------------------*/

#include <string>

#include "gameobject.h"
#include "color.h"

class Vertex3D;

class RenderInterface;
class VertexBuffer;
class TextureInterface;

/*---------------------------------------------------------------
	Class
---------------------------------------------------------------*/


// Class MeshCylinder Using MeshCylinder
class MeshCylinder : public GameObject
{
public:
	
	MeshCylinder(							// MeshCylinder Constructor
		const std::string& filename );	
	~MeshCylinder( );						// MeshCylinder Destructor

	static MeshCylinder* Create( 			// MeshCylinder Create Instance Class
		const std::string& filename );
	
	void Init( void );						// MeshCylinder Initialize
	void Uninit( void );					// MeshCylinder Uninitialize
	void Update( void );					// MeshCylinder Update

	void SetBuffer( void );					// MeshCube SetBuffer
	
	void Resize(							// MeshCube Resize
		const int grid,
		const float radius,
		const float height );

	void Lock( Vertex3D* pVtx );	// Sprite Lock
	void Unlock( void );			// Sprite Unlock

private:

	// Member Variable
	RenderInterface* renderer;
	VertexBuffer* pVtxBuf;
	TextureInterface* pTexture;
	Color color;
	int grid;
	float radius;
	float height;


};


#endif	//	_MESHCYLINDER_H_


