/***************************************************************/
//
//
//		DirectX	[ meshfield.h ]
//
//											Author	kazuki tanaka
//											Date	2017 5/25
/*---------------------------------------------------------------
Update : 2017/5/25
			Create Header File -> meshfield.h.h 
 			< Add Class Function >
				MESHFIELD->Constructor
				MESHFIELD->Destructor
				MESHFIELD->Create ( static member )
				MESHFIELD->Init
				MESHFIELD->Uninit
				MESHFIELD->Update
				MESHFIELD->Draw

Update : 2017/5/25



/*-------------------------------------------------------------*/
#ifndef _MESHFIELD_H_

#define _MESHFIELD_H_

/*---------------------------------------------------------------
	Include File
---------------------------------------------------------------*/

#include "system_component.h"

class RenderInterface;
class VertexBuffer;
class IndexBuffer;
class TextureInterface;

/*---------------------------------------------------------------
	Class
---------------------------------------------------------------*/


// Class MeshField Using MeshField
class MeshField
{
public:
	
	MeshField( );						// MeshField Constructor
	~MeshField( );						// MeshField Destructor

	static MeshField* Create( void );	// MeshField Create Instance Class

	void Init( void );					// MeshField Initialize
	void Uninit( void );				// MeshField Uninitialize
	void Update( void );				// MeshField Update

	void SetBuffer( void );				// MeshField SetBuffer
	void Resize(						// MeshField Resize
		const int size,
		const int vertical,
		const int horizonal );			

	float GetHeight( Vector3 pos );
	float GetSlope( Vector3 pos );

private:

	bool NormalCheck(
		Vector3& pos,
		Vector3& p0,
		Vector3& p1,
		Vector3& p2 );

	float SlopeHeight( 
		Vector3& pos,
		Vector3& p0,
		Vector3& p1,
		Vector3& p2 );

	// Member Variable
	RenderInterface* pObject;
	VertexBuffer* pVtxBuf;
	IndexBuffer*  pIdxBuf;
	TextureInterface* pTexture;
	
	int vertical;
	int horizonal;
	int size;
		
	Vector3 pos;
	Matrix  world;

	Vector3* state;						// @ : fieldStatus


};


#endif	//	_MESHFIELD_H_


