/***************************************************************/
//
//
//		DirectX	[ meshplane.h ]
//
//											Author	kazuki tanaka
//											Date	2017 6/19
/*---------------------------------------------------------------
Update : 2017/6/19
			Create Header File -> meshplane.h.h 
 			< Add Class Function >
				MeshPlane->Constructor
				MeshPlane->Destructor
				MeshPlane->Create ( static member )
				MeshPlane->Init
				MeshPlane->Uninit
				MeshPlane->Update
				MeshPlane->Draw

Update : 2017/6/19



/*-------------------------------------------------------------*/
#ifndef _MESHPLANE_H_

#define _MESHPLANE_H_


/*---------------------------------------------------------------
	Include File
---------------------------------------------------------------*/

#include <string>

#include "gameobject.h"

#include "vector3.h"
#include "matrix.h"
#include "color.h"

class RenderInterface;
class VertexBuffer;
class TextureInterface;
class Vertex3D;

/*---------------------------------------------------------------
	Class
---------------------------------------------------------------*/


// Class MeshPlane Using MeshPlane
class MeshPlane : public GameObject
{
public:
	
	MeshPlane(							// MeshPlane Constructor
		const std::string& filename = "data\\texture\\field.jpg",
		const float& vertical = 10.0f,
		const float& horizonal = 10.0f,
		const Color& color = Color(1,1,1,1),
		const Vector3& pos = Vector3(0,0,0),
		const Vector3& rot = Vector3(0,0,0),
		const Vector3& scale = Vector3(1,1,1),
		const Matrix& mat = Matrix());
	~MeshPlane( );						// MeshPlane Destructor

	static MeshPlane* Create( 
		const std::string& filename,
		const float& vertical = 10.0f,
		const float& horizonal = 10.0f,
		const Color& color = Color(1,1,1,1),
		const Vector3& pos = Vector3(0,0,0),
		const Vector3& rot = Vector3(0,0,0),
		const Vector3& scale = Vector3(1,1,1),
		const Matrix& mat = Matrix());	// MeshPlane Create Instance Class

	void Init( void );					// MeshPlane Initialize
	void Uninit( void );				// MeshPlane Uninitialize
	void Update( void );				// MeshPlane Update

	virtual void SetBuffer( void );		// MeshField SetBuffer
	virtual void Resize(				// MeshField Resize
		const float vertical,
		const float horizonal );
	void SetColor(						// UserInterface SetColor
		const Color& color );
	void ChangeTexture(					// UserInterface Change Texture
		const std::string& filename );

	void Lock( Vertex3D* pVtx );
	void Unlock( void );

	template<class X>X* Inheritance( void ){			// GameObject Inheritance Access
		return dynamic_cast<X*>(this);
	}


protected:

	// Member Variable
	RenderInterface* pObject;
	VertexBuffer* pVtxBuf;
	TextureInterface* pTexture;
	
	Color color;
	float vertical;
	float horizonal;


};


#endif	//	_MESHPLANE_H_


