/***************************************************************/
//
//
//		DirectX	[ meshskydome.h ]
//
//											Author	kazuki tanaka
//											Date	2017 6/18
/*---------------------------------------------------------------
Update : 2017/6/18
			Create Header File -> meshskydome.h.h 
 			< Add Class Function >
				MeshSkydome->Constructor
				MeshSkydome->Destructor
				MeshSkydome->Create ( static member )
				MeshSkydome->Init
				MeshSkydome->Uninit
				MeshSkydome->Update
				MeshSkydome->Draw

Update : 2017/6/18



/*-------------------------------------------------------------*/
#ifndef _MESHSKYDOME_H_

#define _MESHSKYDOME_H_


/*---------------------------------------------------------------
	Include File
---------------------------------------------------------------*/

#include <string>

#include "vector3.h"
#include "matrix.h"

class RenderInterface;
class VertexBuffer;
class IndexBuffer;
class TextureInterface;

/*---------------------------------------------------------------
	Class
---------------------------------------------------------------*/


// Class MeshSkydome Using MeshSkydome
class MeshSkydome
{
public:
	
	MeshSkydome(						// MeshSkydome Constructor
		const std::string& filename = "data\\TEXTURE\\4690241.jpg" );		
	~MeshSkydome( );					// MeshSkydome Destructor

	static MeshSkydome* Create( void );	// MeshSkydome Create Instance Class

	void Init( void );					// MeshSkydome Initialize
	void Uninit( void );				// MeshSkydome Uninitialize
	void Update( void );				// MeshSkydome Update

	void SetBuffer( void );				// MeshSkydome SetBuffer
	void Resize(						// MeshSkydome Resize
		const float radius,
		const int vertical,
		const int horizonal );


private:

	// Member Variable
	RenderInterface* renderer;
	VertexBuffer* pVtxBuf;
	IndexBuffer*  pIdxBuf;
	TextureInterface* pTexture;
	
	Matrix   world;
	Vector3  pos;				// SW
	unsigned int horizonal;		// c
	unsigned int vertical;		// 
	float    radius;			// a
	float    theta;				// Zp
	float    phy;				// yp


};


#endif	//	_MESHSKYDOME_H_


