/***************************************************************/
//
//
//		DirectX	[ modeldx9interface.cpp ]
//
//											Author	kazuki tanaka
//											Date	2017 6/9
/*---------------------------------------------------------------
Update : 2017/6/9
			modeldx9interface.cpp̍쐬

/*---------------------------------------------------------------
	Include File
---------------------------------------------------------------*/


#include "modeldx9_interface.h"

#include "texture_manager.h"
#include "texturedx9_interface.h"

/*---------------------------------------------------------------
	Macro Difinition
---------------------------------------------------------------*/

typedef TextureInterface* LPTextureInterface ;

/*----------------------------------------------------------------
	static member variable Initialize 
----------------------------------------------------------------*/





// ModelDX9Interface Constructor
ModelDX9Interface::ModelDX9Interface( )
	: pMesh(nullptr)
	, pBufMat(nullptr)
	, matNum(0)
	, ppTexture(nullptr)
{

	// Member Clear Process

}

// ModelDX9Interface Destructor
ModelDX9Interface::~ModelDX9Interface( )
{

	// Do Nothing!!

}

// ModelDX9Interface Create Instance 
ModelDX9Interface* ModelDX9Interface::Create( void )
{

	// Create Class Instance
	return new ModelDX9Interface;

}

// ModelDX9Interface Uninitialize
void ModelDX9Interface::Release( void )
{
	
	// Release Modeldata 
	if( pBufMat ){
		D3DXMATERIAL* pMat =( D3DXMATERIAL*)pBufMat -> GetBufferPointer( );
		for( int index = 0; index < (int)matNum; index++ ){
			if( ppTexture[ index ] ){
				ppTexture[ index ]->Release( );
			}
		}
		SAFE_DELETE_ARRAY( ppTexture )
		SAFE_RELEASE( pBufMat )
		SAFE_RELEASE( pMesh )
	}

	
}

// ModelDX9Interface Load
bool ModelDX9Interface::Load( const char* FILE_NAME )
{
	
	// XFileLoad
	HRESULT hr = D3DXLoadMeshFromX( 
		FILE_NAME,
		D3DXMESH_MANAGED,
		GetDevice( ),
		NULL,
		&pBufMat,
		NULL,
		&matNum,
		&pMesh );
	if( FAILED( hr )){
		#ifdef _DEBUG
			#ifdef _DEBUGMANAGER_H_
			CDebugManager::DebugMsg( " [ %s ] MODEL LOAD ERROR!! \n index : [ %d ] \n ERROR_CODE : 0x%x ", MODEL_NAME, index, hr );
			#endif // _DEBUGMANAGER_H_
		#endif	// _DEBUG
		return false;
	}else
	{ // TEXTURE LOAD
	
		// Get MaterialPointer
		D3DXMATERIAL* pMat =( D3DXMATERIAL*)pBufMat -> GetBufferPointer( );

		// Create <TextureBuffer>
		ppTexture = new LPTextureInterface[(int)matNum];

		for( int index = 0; index < (int)matNum; index++ ){

			// Load Texture
			ppTexture[ index ] = TextureDX9Interface::Create( );
			if( pMat[ index ].pTextureFilename ){
				ppTexture[index] = TextureManager::LoadFromManager(pMat[ index ].pTextureFilename);
			}else{
			
				// NULLleNX`}eA
				dynamic_cast< TextureDX9Interface* >(ppTexture[index])->data = nullptr;
			}
		}
	}	// -> END TEXTURE LOAD PROCESS

	return true;

	
}

// ModelDX9Interface GetMesh
LPD3DXMESH ModelDX9Interface::GetMesh( void )
{
	return pMesh;
}

// ModelDX9Interface GetMaterialBuffer
LPD3DXBUFFER ModelDX9Interface::GetMatBuffer( void )
{
	return pBufMat;
}

// ModelDX9Interface GetMatNumber
DWORD ModelDX9Interface::GetMatNumber( void )
{
	return matNum;
}

// ModelDX9Interface GetTexture
TextureInterface* ModelDX9Interface::GetTexture( const int& index )
{
	return ppTexture[ index ];
}


