/***************************************************************/
//
//
//		DirectX	[ renderermanager.h ]
//
//											Author	kazuki tanaka
//											Date	2017 5/10
/*---------------------------------------------------------------
Update : 2017/5/10
			Create Header File -> renderermanager.h.h 
 			< Add Class Function >
				RendererMANAGER->Constructor
				RendererMANAGER->Destructor
				RendererMANAGER->Create ( static member )
				RendererMANAGER->Init
				RendererMANAGER->Uninit
				RendererMANAGER->Update
				RendererMANAGER->Draw

Update : 2017/5/10


/*-------------------------------------------------------------*/
#ifndef _RENDERERMANAGER_H_

#define _RENDERERMANAGER_H_

/*---------------------------------------------------------------
	Include File
---------------------------------------------------------------*/

#include "renderer.h"

/*---------------------------------------------------------------
	Macro Difinition
---------------------------------------------------------------*/

typedef Renderer* (*SelectRenderer)( void );

/*---------------------------------------------------------------
	CLASS
---------------------------------------------------------------*/


// class RendererManager Using RendererManager
class RendererManager
{
public:

	RendererManager( const Renderer::TYPE& type );	// RendererManager constructor
	~RendererManager( );							// RendererManager destructor

	static RendererManager* Create( 
		const Renderer::TYPE& type );				// RendererManager Create Instance Class
	
	Renderer* GetRenderer( void );					// Renderer Get Instance
	Renderer::TYPE& ConfirmRendererType( void );	// Confirm Renderer Type

	void Init( void );								// RendererManager Initialize
	void Uninit( void );							// RendererManager Uninitialize	

private:

	// Member Function
	Renderer* pRenderer;
	Renderer::TYPE rendererType;

	static SelectRenderer pCreateRendererFunc[ Renderer::RENDERER_MAX ];

};


#endif	//	_RENDERERMANAGER_H_


