/***************************************************************/
//
//
//		DirectX	[ rendererdx9.cpp ]
//
//											Author	kazuki tanaka
//											Date	2017 5/10
/*---------------------------------------------------------------
Update : 2017/5/10
			rendererdx9.cpp̍쐬

/*---------------------------------------------------------------
	Include File
---------------------------------------------------------------*/


//#include <Windows.h>
//#include <stdio.h>
//#include <d3dx9.h>

#include "rendererdx9.h"

#include "game_manager.h"
#include "renderer_manager.h"

//#pragma comment (lib,"d3d9.lib")
//#pragma comment (lib,"d3dx9.lib")
//#pragma comment (lib,"dxguid.lib")


/*---------------------------------------------------------------
	Macro Difinition
---------------------------------------------------------------*/


/*---------------------------------------------------------------
	Const Number Difinition
---------------------------------------------------------------*/				


/*----------------------------------------------------------------
	static member variable Initialize 
----------------------------------------------------------------*/



// RendererDX9 Constructor
RendererDX9::RendererDX9( )
	: pD3D(nullptr)
	, pD3DDevice(nullptr)
{

	// Menber Clear Process

}

// RendererDX9 Destructor
RendererDX9::~RendererDX9( )
{

	// Do Nothing!!

}

// RendererDX9 Create Instance 
Renderer* RendererDX9::Create( void )
{

	// Create Class Instance
	RendererDX9* pObject;
	pObject = new RendererDX9;

	return pObject;

}

// RendererDX9 Initialize
void RendererDX9::Init( HWND hWnd, bool bWindow )
{

	// Initialize Process
	
	//DirectX9̐ݒ()
	//IDirect3DDevice9C^[tF[X̎擾

	D3DPRESENT_PARAMETERS d3dpp={0};			// foCX̓ݒ肷\
	D3DDISPLAYMODE d3ddm;						// fBXvC̐ݒ

	pD3D = Direct3DCreate9(D3D_SDK_VERSION);	// D3D9C^[tF[X̎擾
	if( pD3D==NULL ){
		return;
	}

	//݂̃foCX[h̎擾
	if(FAILED( pD3D->GetAdapterDisplayMode(D3DADAPTER_DEFAULT,&d3ddm))){
		return;
	}

	//foCX̃v[e[Vp[^[̐ݒ
	ZeroMemory(&d3dpp,sizeof(d3dpp));

	const int SCREEN_WIDTH  = 1280;
	const int SCREEN_HEIGHT = 720;

	d3dpp.BackBufferWidth=SCREEN_WIDTH;			// backbuffer̃TCY()
	d3dpp.BackBufferHeight=SCREEN_HEIGHT;		// backbuffer̃TCY(c)
	d3dpp.BackBufferFormat=d3ddm.Format;		// FULLSCREEN̂Ƃ͂̌ł͂ȂAWINDOWMODE͕
	d3dpp.BackBufferCount=1;					// backBuffer̐
	d3dpp.SwapEffect=D3DSWAPEFFECT_DISCARD;		// doubleBuffer̐؂ւ
	d3dpp.EnableAutoDepthStencil=TRUE;			// dv ;DepthStencil̎gp
	d3dpp.AutoDepthStencilFormat=D3DFMT_D16;	// D3DtH[}bg̐ݒ
	d3dpp.Windowed=bWindow;						// WindowMode trueŃEBhE falseFullScreen(WindowStylepopup)
	d3dpp.FullScreen_RefreshRateInHz
	=D3DPRESENT_RATE_DEFAULT;					// Xs[h(fullscreen̂Ƃ̂ݐݒ\)
	d3dpp.PresentationInterval
	=D3DPRESENT_INTERVAL_DEFAULT;				// fullscreen̎̂ 邩ǂ

	//Direct3DfoCX̐ݒ
	if(FAILED( pD3D ->CreateDevice(
	D3DADAPTER_DEFAULT,							// ftHg̃A_v^[擾
	D3DDEVTYPE_HAL,								// `揈type̎w(n[hł邩\tgł邩)HAL=n[h
	hWnd,										// ǂ̃EBhȄɍ쐬邩(tH[JXEBhE)
	D3DCREATE_HARDWARE_VERTEXPROCESSING | D3DCREATE_MULTITHREADED,		// foCX쐬IvVtO(̓n[hEFAŒ_)
	&d3dpp,										// ̑ݒ
	&pD3DDevice )))								// foCX̃|C^̃|C^
	//sNULLԂ
	{

		MessageBox( hWnd, "x܂", "", MB_OK );
		if(FAILED( pD3D ->CreateDevice(
		D3DADAPTER_DEFAULT,							// ftHg̃A_v^[擾
		D3DDEVTYPE_HAL,								// `揈type̎w(n[hł邩\tgł邩)HAL=n[h
		hWnd,										// ǂ̃EBhȄɍ쐬邩(tH[JXEBhE)
		D3DCREATE_SOFTWARE_VERTEXPROCESSING,		// foCX쐬IvVtO(̓\tgEFAŒ_)
		&d3dpp,										// ̑ݒ
		&pD3DDevice )))								// foCX̃|C^̃|C^
		{	

			if(FAILED( pD3D ->CreateDevice(
			D3DADAPTER_DEFAULT,							// ftHg̃A_v^[擾
			D3DDEVTYPE_REF,								// `揈type̎w(n[hł邩\tgł邩)
			hWnd,										// ǂ̃EBhȄɍ쐬邩(tH[JXEBhE)
			D3DCREATE_SOFTWARE_VERTEXPROCESSING,		// foCX쐬IvVtO(̓\tgEFAŒ_)
			&d3dpp,										// ̑ݒ
			&pD3DDevice )))								// foCX̃|C^̃|C^
			{
				return;
			}
		}
	}
		 
	// _\Xe[g̐ݒ
	//pD3DDevice->SetRenderState(D3DRS_CULLMODE, D3DCULL_CW);					// v𗠖ʂƂ
	pD3DDevice->SetRenderState( D3DRS_CULLMODE, D3DCULL_CCW );					// v𗠖ʂƂ
	//pD3DDevice->SetRenderState(D3DRS_CULLMODE, D3DCULL_NONE);					// ʂ`悷

	pD3DDevice->SetRenderState( D3DRS_FILLMODE, D3DFILL_SOLID );				// |Sŕ`
	//pD3DDevice->SetRenderState(D3DRS_FILLMODE,D3DFILL_WIREFRAME);				// |SC[t[ŕ`

	// ݉ʂɕ`ĂԂɂč`悷e
	pD3DDevice->SetRenderState( D3DRS_ALPHABLENDENABLE, TRUE );					// 
	pD3DDevice->SetRenderState( D3DRS_SRCBLEND, D3DBLEND_SRCALPHA );			// ̃
	pD3DDevice->SetRenderState( D3DRS_DESTBLEND, D3DBLEND_INVSRCALPHA );		// ̃(INV͋ẗӖ,ł̓l̋t)

	// eXg̐ݒ
	pD3DDevice->SetRenderState( D3DRS_ALPHATESTENABLE, FALSE );
	pD3DDevice->SetRenderState( D3DRS_ALPHAREF, 128 );
	pD3DDevice->SetRenderState( D3DRS_ALPHAFUNC, D3DCMP_GREATEREQUAL );

	// Tv[Xe[g̐ݒ(stagesteat texturestate)
	pD3DDevice->SetSamplerState( 0, D3DSAMP_MINFILTER, D3DTEXF_LINEAR );
	pD3DDevice->SetSamplerState( 0, D3DSAMP_MAGFILTER, D3DTEXF_LINEAR );

	pD3DDevice->SetSamplerState( 0, D3DSAMP_ADDRESSU, D3DTADDRESS_MIRROR );
	pD3DDevice->SetSamplerState( 0, D3DSAMP_ADDRESSV, D3DTADDRESS_WRAP );
	//pD3DDevice->SetSamplerState(0, D3DSAMP_ADDRESSU, D3DTADDRESS_CLAMP);
	//pD3DDevice->SetSamplerState(0, D3DSAMP_ADDRESSV, D3DTADDRESS_CLAMP);
	
	// eNX`Xe[g̐ݒ( ߏݒ )
	pD3DDevice->SetTextureStageState( 0, D3DTSS_COLORARG1, D3DTA_TEXTURE );
	pD3DDevice->SetTextureStageState( 0, D3DTSS_COLORARG2, D3DTA_DIFFUSE );
	pD3DDevice->SetTextureStageState( 0, D3DTSS_COLOROP, D3DTOP_MODULATE );

	pD3DDevice->SetTextureStageState( 0, D3DTSS_ALPHAARG1, D3DTA_TEXTURE );
	pD3DDevice->SetTextureStageState( 0, D3DTSS_ALPHAARG2, D3DTA_DIFFUSE );
	pD3DDevice->SetTextureStageState( 0, D3DTSS_ALPHAOP, D3DTOP_MODULATE );



}

// RendererDX9 Uninitialize
void RendererDX9::Uninit( void )
{

	{ // Uninitialize Process
	
		// foCX̔j
		SAFE_RELEASE( pD3DDevice )

		// Direct3DIuWFNg̔j
		SAFE_RELEASE( pD3D )

	}	// -> End
}

// RendererDX9 Draw Start
bool RendererDX9::RenderBegin( void )
{

	// Draw Begin Process

	D3DXCOLOR screenClearColor = D3DCOLOR_RGBA(192,192,192,0);
	
	// obNobt@Zobt@̃NA
	pD3DDevice->Clear(0,NULL,
	D3DCLEAR_TARGET								// F
	| D3DCLEAR_ZBUFFER,							// [x
	screenClearColor,							// NAF
	1.0f,										// NA[xl
	0);											// XeVl

	// `̊Jn
	if( SUCCEEDED( pD3DDevice ->BeginScene( ) )) {
		return true;
	}

	return false;
}

// RendererDX9 Draw End
void RendererDX9::RenderEnd( void )
{

	// Draw End Process
	pD3DDevice->EndScene( );
	
}

// RendererDX9 Present 
void RendererDX9::Present( void )
{

	// Present Process
	pD3DDevice->Present( NULL, NULL, NULL, NULL );
	
}

// RendererDX9 GetDevice
LPDIRECT3DDEVICE9 RendererDX9::GetDevice( void )
{

	// return DirectX9 Device Object
	return pD3DDevice;

}

// RendererDX9 SetRenderState
void RendererDX9::RenderState( int* stateArray, bool* flaglist, int dataNumber )
{

	for( int index = 0; index < dataNumber; index++ ){
		pD3DDevice->SetRenderState( (D3DRENDERSTATETYPE)stateArray[index], flaglist[index] );
	}

}

// Global Func : Get Device
LPDIRECT3DDEVICE9 RendererDevice::GetDevice( void )
{

	Renderer* pRenderer= GameManager::Operate( )->GetRendererManager( )->GetRenderer( );
	return	(dynamic_cast< RendererDX9* >(pRenderer)->GetDevice());

}





