/***************************************************************/
//
//
//		DirectX	[ renderingorder.h ]
//
//											Author	kazuki tanaka
//											Date	2017 5/24
/*---------------------------------------------------------------
Update : 2017/5/24
			Create Header File -> renderingorder.h.h 
 			< Add Class Function >
				RENDERINGORDER->Constructor
				RENDERINGORDER->Destructor
				RENDERINGORDER->Create ( static member )
				RENDERINGORDER->Init
				RENDERINGORDER->Uninit
				RENDERINGORDER->Update
				RENDERINGORDER->Draw

Update : 2017/5/24



/*-------------------------------------------------------------*/
#ifndef _RENDERINGORDER_H_

#define _RENDERINGORDER_H_


/*---------------------------------------------------------------
	Include File
---------------------------------------------------------------*/

class VertexBuffer;
class IndexBuffer;
class ModelInterface;
class TextureInterface;
class Matrix;

/*---------------------------------------------------------------
	Class
---------------------------------------------------------------*/


// Class RenderingOrder Using RenderingOrder
class RenderingOrder
{
public:
	
	RenderingOrder( );								// RenderingOrder Constructor
	virtual ~RenderingOrder( );						// RenderingOrder Destructor

	virtual void DrawPrimitiveStrip(				// RenderingOrder DrawPrimitive
		VertexBuffer* pVtxBuf,
		TextureInterface* pTexture = nullptr,
		Matrix* mtx = nullptr );
	virtual void DrawPrimitiveList(					// RenderingOrder DrawPrimitive
		VertexBuffer* pVtxBuf,
		TextureInterface* pTexture = nullptr,
		Matrix* mtx = nullptr );
	virtual void DrawPrimitiveFan(					// RenderingOrder DrawPrimitive
		VertexBuffer* pVtxBuf,
		TextureInterface* pTexture = nullptr,
		Matrix* mtx = nullptr );
	virtual void DrawSubset( 						// RenderingOrder DrawSubset
		ModelInterface* pMeshObj,
		Matrix* mtx = nullptr );
	
	virtual void DrawIndexPrimitive( 				// RenderingOrder DrawIndexPrimitive
		VertexBuffer* pVtxBuf,
		IndexBuffer* pIdxBuf,
		TextureInterface* pTexture = nullptr,
		Matrix* mtx = nullptr );

	virtual void DrawLineStrip(						// RenderingOrder DrawLineStrip
		VertexBuffer* pVtxBuf );

	virtual void DrawBillboard( 
		VertexBuffer* pVtxBuf,
		TextureInterface* pTexture = nullptr,
		Matrix* mtx = nullptr );

	virtual void Draw3DUserInterface( 
		VertexBuffer* pVtxBuf,
		TextureInterface* pTexture = nullptr,
		Matrix* mtx = nullptr );

	virtual void DrawLineList(
		VertexBuffer* pVtxBuf,
		Matrix* mtx );

	virtual void DrawPrimitiveCurringOff(			// RenderingOrder DrawPrimitive CurringOff
		VertexBuffer* pVtxBuf,
		TextureInterface* pTexture,
		Matrix* mtx	);

	virtual void DrawReverseObject(					// RenderingOrder DrawPrimitive CurringOff
		VertexBuffer* pVtxBuf,
		IndexBuffer* pIdxBuf,
		TextureInterface* pTexture,
		Matrix* mtx	);

	// for Ortho Coord
	virtual void DrawSprite(
		VertexBuffer* pVtxBuf,
		TextureInterface* pTexture = nullptr ) = 0;

	virtual void DrawSpriteEx(
		VertexBuffer* pVtxBuf,
		IndexBuffer* pIdxBuf,
		TextureInterface* pTexture = nullptr ) = 0;

private:

	// Member Variable

};


#endif	//	_RENDERINGORDER_H_


