/***************************************************************/
//
//
//		DirectX	[ scenemanager.h ]
//
//											Author	kazuki tanaka
//											Date	2017 5/15
/*---------------------------------------------------------------
Update : 2017/5/15
			Create Header File -> scenemanager.h.h 
 			< Add Class Function >
				ScENEMANAGER->Constructor
				ScENEMANAGER->Destructor
				ScENEMANAGER->Create ( static member )
				ScENEMANAGER->Init
				ScENEMANAGER->Uninit
				ScENEMANAGER->Update
				ScENEMANAGER->Draw

Update : 2017/5/15



/*-------------------------------------------------------------*/
#ifndef _SCENEMANAGER_H_

#define _SCENEMANAGER_H_

/*---------------------------------------------------------------
	Include File
---------------------------------------------------------------*/

#include "scene.h"

typedef Scene* (*SelectScene)( void );

/*---------------------------------------------------------------
	Class
---------------------------------------------------------------*/


// class SceneManager Using SceneManager
class SceneManager
{
public:
	
	SceneManager( );						// SceneManager constructor
	~SceneManager( );						// SceneManager destructor

	static SceneManager* Create( void );	// SceneManager Create Instance Class

	void Init( 								// SceneManager Initialize
		const Scene::SCENE& scene );

	void Init( Scene* pScene );				// SceneManager Initialize
	void Uninit( void );					// SceneManager Uninitialize

	Scene* GetScene( void );				// SceneManager GetSceneInstanceAddress
	
	static void ChangeScene( 				// Scene Change
		const Scene::SCENE& nextScene );
	
	static void ChangeScene( 				// Scene Change
			Scene* pScene );

private:

	// Member Function
	Scene* pScene;							// Scene Status
	
	static SceneManager* pManager;			// SceneManager : Registry Instance Address
	
	static SelectScene pSceneFunc[ Scene::SCENE_MAX ];

};


#endif	//	_SCENEMANAGER_H_


