/***************************************************************/
//
//
//		DirectX	[ screentransition.h ]
//
//											Author	kazuki tanaka
//											Date	2017 6/8
/*---------------------------------------------------------------
Update : 2017/6/8
			Create Header File -> screentransition.h.h 
 			< Add Class Function >
				SCREENTRANSITION->Constructor
				SCREENTRANSITION->Destructor
				SCREENTRANSITION->Create ( static member )
				SCREENTRANSITION->Init
				SCREENTRANSITION->Uninit
				SCREENTRANSITION->Update
				SCREENTRANSITION->Draw

Update : 2017/6/8



/*-------------------------------------------------------------*/
#ifndef _SCREENTRANSITION_H_

#define _SCREENTRANSITION_H_


/*---------------------------------------------------------------
	IncludeFile + other
---------------------------------------------------------------*/

class Scene;
class SwapEffect;

/*---------------------------------------------------------------
	Class
---------------------------------------------------------------*/


// Class ScreenTransition Using ScreenTransition
class ScreenTransition
{
public:
	
	typedef enum{
		
		NOTHING = 0,
		DO_TRANSITION,
		SWITCH,
		TRANSITION_END,
	}STATE;
	
	ScreenTransition( );						// ScreenTransition Constructor
	~ScreenTransition( );						// ScreenTransition Destructor

	static ScreenTransition* Create( void );	// ScreenTransition Create Instance Class
	
	void Release( void );						// ScreenTransition Release
	void Update( void );						// ScreenTransition TransitionProcess

	static void RegistrySwapEffect( 			// ScreenTransition RegistrySwapEffect
		SwapEffect* swapEffect );
	
	static void Transition(						// ScreenTransition use flag Change
		STATE state,
		Scene* next = nullptr );
private:

	// Member Variable
	SwapEffect* swapEffect;
	Scene*      next;
	STATE       state;
	
	static ScreenTransition* instance;

};


#endif	//	_SCREENTRANSITION_H_


