/***************************************************************/
//
//
//		DirectX	[ shell.cpp ]
//
//											Author	kazuki tanaka
//											Date	2017 6/8
/*---------------------------------------------------------------
Update : 2017/6/8
			shell.cpp̍쐬

/*---------------------------------------------------------------
	Include File
---------------------------------------------------------------*/


#include "shell.h"

#include "explosion.h"
#include "fieldmap.h"

/*---------------------------------------------------------------
	Macro Difinition
---------------------------------------------------------------*/


/*---------------------------------------------------------------
	Const Number Difinition
---------------------------------------------------------------*/


/*----------------------------------------------------------------
	static member variable Initialize 
----------------------------------------------------------------*/





// Shell Constructor
Shell::Shell( )
	: awakeflag(false)
	, moveflag(false)
	, dir(0)
	, Base( FieldMap::MOVE )
{

	// Menber Clear Process
}

// Shell Destructor
Shell::~Shell( )
{

	// Do Nothing!!

}

// Shell Create Instance 
Shell* Shell::Create( void )
{

	// Create Class Instance
	Shell* pObject;
	pObject = new Shell;

	return pObject;

}

// Shell Initialize
void Shell::Init( void )
{

	// Initialize Process
	Base::Init();


}

// Shell Uninitialize
void Shell::Uninit( void )
{

	// Uninitialize Process
	Base::Uninit();


}

// Shell Update
void Shell::Update( void )
{

	// Update Process
	rot = Vector3( 0, D3DX_PI*0.5f*dir+D3DX_PI, 0 );

	if(awakeflag && moveflag ){

		if( dir == DIR_UP ){
			pos.z-=1;
		}
		if( dir == DIR_DOWN ){
			pos.z+=1;
		}
		if( dir == DIR_RIGHT ){
			pos.x-=1;
		}
		if( dir == DIR_LEFT ){
			pos.x+=1;
		}
	}

	Base::Update();


}

// Shell Draw
void Shell::Draw( void )
{

	// Draw Process
	Base::Draw();

}

// Shell Contact Process
void Shell::OnContact( void )
{

}

// Shell Contact Process
void Shell::OnScissor( void )
{

	if( onScissor ){
		return;
	}

	Base::OnScissor();
	Base::Scissor();

	moveflag = true;

	if(!awakeflag){
		awakeflag = true;
		return;
	}

	if(awakeflag){
	 
		dir++;
		if( dir >= DIR_MAX ){
		
			dir = 0;
		}
	}
	

}

// Shell Contact Process
void Shell::Scissor( void )
{
	//SetExplosion( &D3DXVECTOR3( pos.x, pos.y, pos.z ) );

	/*
	if( scissor ){
		return;
	}*/

	moveflag = true;
	
	if(awakeflag){
		switch(dir)
		{
		case DIR_UP:
			dir = DIR_DOWN;
			break;
		case DIR_DOWN:
			dir = DIR_UP;
			break;
		case DIR_LEFT:
			dir = DIR_RIGHT;
			break;
		case DIR_RIGHT:
			dir = DIR_LEFT;
		}
	}


}

// Shell Set <Direction>
void Shell::SetDirection( int dir )
{

	Shell::dir = dir;

}





