/***************************************************************/
//
//
//		DirectX	[ swapeffect.h ]
//
//											Author	kazuki tanaka
//											Date	2017 6/8
/*---------------------------------------------------------------
Update : 2017/6/8
			Create Header File -> swapeffect.h.h 
 			< Add Class Function >
				SWAPEFFECT->Constructor
				SWAPEFFECT->Destructor
				SWAPEFFECT->Create ( static member )
				SWAPEFFECT->Init
				SWAPEFFECT->Uninit
				SWAPEFFECT->Update
				SWAPEFFECT->Draw

Update : 2017/6/8



/*-------------------------------------------------------------*/
#ifndef _SWAPEFFECT_H_

#define _SWAPEFFECT_H_

/*---------------------------------------------------------------
	Class
---------------------------------------------------------------*/


// Class SwapEffect Using SwapEffect
class SwapEffect
{
public:
	
	SwapEffect( );								// SwapEffect Constructor
	~SwapEffect( );								// SwapEffect Destructor

	static SwapEffect* Create( void );			// SwapEffect Create Instance Class

	// SwapEffect Create Instance 
	template<class X> static X* Instance( void )
	{
		return new X;
	}

	virtual void Init( void );					// SwapEffect Initialize
	virtual void Uninit( void );				// SwapEffect Uninitialize
	virtual void Update( void );				// SwapEffect Update

	// call Back func
	virtual void DoTransition( void );			// ScreenTransition DoTransition
	virtual bool Switch( void );				// ScreenTransition Uninitialize
	virtual void TransitionEnd( void );			// ScreenTransition Update


private:

	// Member Variable


};


#endif	//	_SWAPEFFECT_H_


