/***************************************************************/
//
//
//		DirectX	[ systempipeline.h ]
//
//											Author	kazuki tanaka
//											Date	2017 6/9
/*---------------------------------------------------------------
Update : 2017/6/9
			Create Header File -> systempipeline.h.h 
 			< Add Class Function >
				SYSTEMPIPELINE->Constructor
				SYSTEMPIPELINE->Destructor
				SYSTEMPIPELINE->Create ( static member )
				SYSTEMPIPELINE->Init
				SYSTEMPIPELINE->Uninit
				SYSTEMPIPELINE->Update
				SYSTEMPIPELINE->Draw

Update : 2017/6/9



/*-------------------------------------------------------------*/
#ifndef _SYSTEMPIPELINE_H_

#define _SYSTEMPIPELINE_H_


/*---------------------------------------------------------------
	Include File
---------------------------------------------------------------*/

/*---------------------------------------------------------------
	Macro Difinition
---------------------------------------------------------------*/

class SceneManager;

class ScreenTransition;

/*---------------------------------------------------------------
	Class
---------------------------------------------------------------*/


// Class SystemPipeline Using SystemPipeline
class SystemPipeline
{
public:
	
	SystemPipeline( );						// SystemPipeline Constructor
	~SystemPipeline( );						// SystemPipeline Destructor

	static SystemPipeline* Create( void );	// SystemPipeline Create Instance Class

	void Init( void );						// SystemPipeline Initialize
	void Uninit( void );					// SystemPipeline Uninitialize
	void Update( void );					// SystemPipeline Update
	void Render( void );					// SystemPipeline Draw

	static void SetCamera(					// SystemPipeline SetCamera
		const int number );

private:

	// Member Variable
	SceneManager*     pSceneManager;
	ScreenTransition* transition;

	int cameraNumber;

	static SystemPipeline* system;

};


#endif	//	_SYSTEMPIPELINE_H_


