/***************************************************************/
//
//
//		DirectX	[ texturedx9interface.cpp ]
//
//											Author	kazuki tanaka
//											Date	2017 5/17
/*---------------------------------------------------------------
Update : 2017/5/17
			texturedx9interface.cpp̍쐬

/*---------------------------------------------------------------
	Include File
---------------------------------------------------------------*/

#include "texturedx9_interface.h"
#include "texture_manager.h"

#include "rendererdx9.h"

#include "game_manager.h"
#include "window.h"

/*---------------------------------------------------------------
	Macro Difinition
---------------------------------------------------------------*/


/*---------------------------------------------------------------
	Const Number Difinition
---------------------------------------------------------------*/

/*----------------------------------------------------------------
	static member variable Initialize 
----------------------------------------------------------------*/





// TextureDX9Interface Constructor
TextureDX9Interface::TextureDX9Interface( )
	: data( nullptr )
{

	// Menber Clear Process

}

// TextureDX9Interface Destructor
TextureDX9Interface::~TextureDX9Interface( )
{

	// Do Nothing!!

}

// TextureDX9Interface Create Instance 
TextureDX9Interface* TextureDX9Interface::Create( void )
{

	// Create Class Instance
	TextureDX9Interface* pObject;
	pObject = new TextureDX9Interface;

	return pObject;

}

// TextureDX9Interface Initialize
void TextureDX9Interface::Release( void )
{

	// Release Process
	SAFE_RELEASE( data )


}

// TextureDX9Interface SetTexture
void TextureDX9Interface::SetTexture( void )
{

	// TextureDX9Interface SetTexture
	GetDevice( )->SetTexture( 0, data );

}

// TextureDX9Interface Load
bool TextureDX9Interface::Load( const char* FILE_NAME )
{

	// texture format
	const int TEXTURE_FORMAT_MAX = 6;
	const char* TEXTURE_FORMAT[ ] = {
		".jpg",
		".png",
		".tga",
		".bmp",
		".dds",
		".jpeg",
	};
	
	// video format
	const int VIDEO_FORMAT_MAX = 1;
	const char* VIDEO_FORMAT[ ] = {
		".avi",
	};
	
	// Divide File Name
	char filename [256] = { };		// t@Cl[
	char extension[256] = { };		// gq
	char loadFile [256] = { };		// [ht@Cl[

	// Split Path
	_splitpath( FILE_NAME, NULL, NULL, filename, extension );
	
	// Synthesis String < Load File Name >
	sprintf( loadFile, "%s%s", filename , extension );
	
	// Create Texture Interface Process
	for( int index = 0; index < TEXTURE_FORMAT_MAX; index++ ){

		if( strcmp( extension, TEXTURE_FORMAT[index] ) == 0 ){
			
			if( FAILED( D3DXCreateTextureFromFile( GetDevice( ), FILE_NAME, &data )))
			{
				#ifdef _DEBUG
				MessageBox( NULL, loadFile , "Create Texture File ERROR!! : texturedx9_interface.cpp", MB_OK | MB_ICONWARNING );
				#endif	// _DEBUG
				return false;
			}else{
				return true;	
			}
		}
	}
	
	
	return false;

}



