/***************************************************************/
//
//
//		DirectX	[ texturegl.h ]
//
//											Author	kazuki tanaka
//											Date	2017 4/25
/*---------------------------------------------------------------
Update : 2017/4/25
			Create Header File -> texturegl.h.h 
 			< Add Class Function >
				CTEXTUREGL->Constructor
				CTEXTUREGL->Destructor
				CTEXTUREGL->Create ( static member )
				CTEXTUREGL->Init
				CTEXTUREGL->Uninit
				CTEXTUREGL->Update
				CTEXTUREGL->Draw

Update : 2017/4/25



/*-------------------------------------------------------------*/
#ifndef _TEXTUREGL_H_

#define _TEXTUREGL_H_

#include <string>

/*---------------------------------------------------------------
	class
---------------------------------------------------------------*/


// class CTextureGL Using TextureGL
class CTextureGL
{
public:
	CTextureGL( );							// CTextureGL constructor
	~CTextureGL( );						// CTextureGL destructor

	static CTextureGL* Create( void );	// CTextureGL Create Instance Class

	void Init( void );				// CTextureGL Initialize
	void Uninit( void );			// CTextureGL Uninitialize
	void Update( void );			// CTextureGL Update
	void Draw( void );				// CTextureGL Draw

	static unsigned int GLTextureLoadFromTga( 
		const std::string& fileName );

	static unsigned int GLTextureLoadFromPng( 
		const std::string& fileName );

private:

	// Member Function


};


#endif	//	_TEXTUREGL_H_


