/***************************************************************/
//
//
//		Aus System	[ Vector2.cpp ]
//
//											Author	kazuki tanaka
//											Date	2017 4/24
/*---------------------------------------------------------------
Update : 2017/4/24
			Vector2.cpp̍쐬

/*---------------------------------------------------------------
	Include File
---------------------------------------------------------------*/


//#include <Windows.h>
//#include <stdio.h>
//#include <d3dx9.h>

//#include "main.h"
#include <Windows.h>
#include <math.h>
#include "vector2.h"

//#pragma comment (lib,"d3d9.lib")
//#pragma comment (lib,"d3dx9.lib")
//#pragma comment (lib,"dxguid.lib")


/*---------------------------------------------------------------
	Macro Difinition
---------------------------------------------------------------*/

#define SAFE_RELEASE(p) { if (p) { (p)->Release(); (p)=NULL; } }


/*---------------------------------------------------------------
	Const Number Difinition
---------------------------------------------------------------*/

#define NUM_VERTEX  ( 4 )						
#define NUM_POLYGON ( 2 )						

/*----------------------------------------------------------------
	static member variable Initialize 
----------------------------------------------------------------*/





// Vector2 Constructor
Vector2::Vector2( )
	: x(0.0f) 
	, y(0.0f)

{

	// Menber Clear Process
	

}

// Vector2 Destructor
Vector2::~Vector2( )
{

	// Do Nothing!!

}

// Vector2 Constructor
Vector2::Vector2( const float* ref )
	: x(*ref) 
	, y(*ref)
{

	// Menber Clear Process
	

}

// Vector2 Constructor
Vector2::Vector2( const Vector2& other )
	: x(other.x) 
	, y(other.y)
{

	// Menber Clear Process
	

}

// Vector2 Constructor
Vector2::Vector2( float x, float y )
	: x(x) 
	, y(y)
{

	// Menber Clear Process
	

}

// Vector2 Calc Length
float Vector2::Length( void ) const
{

	return sqrt( Dot(*this) );

}

// Vector2 Vec Distance
float Vector2::Distance( const Vector2& other ) const
{

	return (*this - other ).Length( );

}

// Vector2 Normalize
Vector2 Vector2::Normalize( void ) const
{

	return *this/Length( );

}

// Vector2 Operator Cross
Vector2 Vector2::Cross( const Vector2& other ) const
{

	return *this;

}

// Vector2 Operator Dot
float Vector2::Dot( const Vector2& other ) const
{

	return ( x * other.x + y + other.y );

}

// Vector2 Operator Angle
float Vector2::Angle( Vector2& other )
{

	float dot = this->Dot( other );
	float lengthA,lengthB;
	lengthA = Length( );
	lengthB = other.Length( );

	return acosf( dot / (lengthA * lengthB) );

}

// Vector3 Cast Vector3 Platform DirectX 
#ifdef _PLATFORM_DIRECTX_
D3DXVECTOR2 Vector2::CastPlatform( void )
{
	return D3DXVECTOR3( x, y );
}
#endif // _PLATFORM_DIRECTX_

// Vector3 Cast Vector3 Platform OpenGL 
#ifdef _PLATFORM_OPENGL_
Vector2 Vector2::CastPlatform( void )
{
	return Vector3( x, y );
}
#endif // _PLATFORM_OPENGL_

