/***************************************************************/
//
//
//		DirectX	[ audio.h ]
//
//											Author	kazuki tanaka
//											Date	2017 6/19
/*---------------------------------------------------------------
Update : 2017/6/19
			Create Header File -> audio.h.h 
 			< Add Class Function >
				Audio->Constructor
				Audio->Destructor
				Audio->Create ( static member )
				Audio->Init
				Audio->Uninit
				Audio->Update
				Audio->Draw

Update : 2017/6/19



/*-------------------------------------------------------------*/
#ifndef _AUDIO_H_

#define _AUDIO_H_


/*---------------------------------------------------------------
	include File
---------------------------------------------------------------*/

#include <string>

/*---------------------------------------------------------------
	Class
---------------------------------------------------------------*/


// Class Audio Using Audio
class Audio
{
public:
	
	Audio( );						// Audio Constructor
	~Audio( );						// Audio Destructor
	
	virtual void Play( void ) = 0;	// Audio Play
	virtual void Stop( void ) = 0;	// Audio Stop

	template<class X>X* Use( void )
	{
		return dynamic_cast<X*>(this);
	}

	template<class X>static Audio* Create( 
		const std::string& sound,
		bool loop )	// Audio Create Instance Class
	{
		return new X( sound, loop );
	}

private:

	// Member Variable
	long volume;					// {[l
	bool loop;						// [vtO


};


#endif	//	_AUDIO_H_


