/***************************************************************/
//
//
//		DirectX	[ base.h ]
//
//											Author	kazuki tanaka
//											Date	2017 6/7
/*---------------------------------------------------------------
Update : 2017/6/7
			Create Header File -> base.h.h 
 			< Add Class Function >
				BASE->Constructor
				BASE->Destructor
				BASE->Create ( static member )
				BASE->Init
				BASE->Uninit
				BASE->Update
				BASE->Draw

Update : 2017/6/7



/*-------------------------------------------------------------*/
#ifndef _BASE_H_

#define _BASE_H_


/*---------------------------------------------------------------
	Include File
---------------------------------------------------------------*/

#include "model.h"
#include "vector2.h"

/*---------------------------------------------------------------
	Class
---------------------------------------------------------------*/


// Class Base Using Base
class Base : public Model
{
public:

	Base( int type = 2 );				// Base Constructor
	~Base( );							// Base Destructor

	static Base* Create( void );		// Base Create Instance Class

	void Init( void ) override;			// Base Initialize
	void Uninit( void ) override;		// Base Uninitialize
	void Update( void ) override;		// Base Update
	void Draw( void );					// Base Draw
	
	void OnContact( void ) override;	// Base OnContact
	
	void SetType( int type );			// Base SetType

	void SetPosition(					// Base SetPosition
		const Vector3& pos );


	bool FieldOut( void ){
	
		if( map == Vector2(-1,-1) ){
			return true;
		}
		return false;
	}

	virtual void OnScissor( void )
	{ 
		onScissor = true;
	}	// ͂܂ꂽƂ

	virtual void Scissor( void )
	{ 
		scissor = true;
	}	// ͂񂾂Ƃ

	Vector3 prev;
	Vector2 map;

protected:

	// Member Variable
	int type;
	bool scissor;
	bool onScissor;
	

};


#endif	//	_BASE_H_


