/***************************************************************/
//
//
//		DirectX	[ collision.cpp ]
//
//											Author	kazuki tanaka
//											Date	2017 6/16
/*---------------------------------------------------------------
Update : 2017/6/16
			collision.cpp̍쐬

/*---------------------------------------------------------------
	Include File
---------------------------------------------------------------*/


#include "collision.h"


/*---------------------------------------------------------------
	Macro Difinition
---------------------------------------------------------------*/


/*----------------------------------------------------------------
	static member variable Initialize 
----------------------------------------------------------------*/




// XN[W[hWɕϊ
D3DXVECTOR3* Collision::Collision3D::CalcScreenToWorld(
	D3DXVECTOR3* pout,
	int Sx,  // XN[XW
	int Sy,  // XN[YW
	float fZ,  // ˉeԂłZli0`1j
	int Screen_w,
	int Screen_h,
	D3DXMATRIX* View,
	D3DXMATRIX* Prj
) {

	// es̋tsZo
	D3DXMATRIX InvView, InvPrj, VP, InvViewport;
	D3DXMatrixInverse( &InvView, NULL, View );
	D3DXMatrixInverse( &InvPrj, NULL, Prj );
	D3DXMatrixIdentity( &VP );
	VP._11 = Screen_w/2.0f; VP._22 = -Screen_h/2.0f;
	VP._41 = Screen_w/2.0f; VP._42 = Screen_h/2.0f;
	D3DXMatrixInverse( &InvViewport, NULL, &VP );

	// tϊ
	D3DXMATRIX tmp = InvViewport * InvPrj * InvView;
	D3DXVec3TransformCoord( pout, &D3DXVECTOR3(Sx,Sy,fZ), &tmp );

	return pout;

}

// XZʂƃXN[W̌_Zo֐
D3DXVECTOR3* Collision::Collision3D::CalcScreenToXZ(
	D3DXVECTOR3* pout,
	int Sx,
	int Sy,
	int Screen_w,
	int Screen_h,
	D3DXMATRIX* View,
	D3DXMATRIX* Prj
) {

	D3DXVECTOR3 nearpos;
	D3DXVECTOR3 farpos;
	D3DXVECTOR3 ray;
	CalcScreenToWorld( &nearpos, Sx, Sy, 0.0f, Screen_w, Screen_h, View, Prj );
	CalcScreenToWorld( &farpos, Sx, Sy, 1.0f, Screen_w, Screen_h, View, Prj );
	ray = farpos - nearpos;
	D3DXVec3Normalize( &ray, &ray );

	// Ƃ̌NĂꍇ͌_
	// NĂȂꍇ͉̕ǂƂ̌_o
	if( ray.y <= 0 ) {
		// _
		float Lray = D3DXVec3Dot( &ray, &D3DXVECTOR3(0,1,0) );
		float LP0 = D3DXVec3Dot( &(-nearpos), &D3DXVECTOR3(0,1,0) );
		*pout = nearpos + (LP0/Lray)*ray;
	}
	else {
		*pout = farpos;
	}

	return pout;
}





