/***************************************************************/
//
//
//		DirectX	[ debugfont.cpp ]
//
//											Author	kazuki tanaka
//											Date	2017 1/31
/*---------------------------------------------------------------
Update : 2017/1/31
			Create CPP -> debugfont.cpp

/*---------------------------------------------------------------
	include File
---------------------------------------------------------------*/

//#include <Windows.h>
//#include <stdio.h>
//#include <d3dx9.h>

#include <stdio.h>

#include "window.h"

#include "d_font.h"

#include "renderer.h"
#include "rendererdx9.h"
#include "game_manager.h"

//#pragma comment (lib,"d3d9.lib")
//#pragma comment (lib,"d3dx9.lib")
//#pragma comment (lib,"dxguid.lib")

/*----------------------------------------------------------------
	static member variable Initialize
----------------------------------------------------------------*/

CDebugFont* CDebugFont::pDebugFont[ CDF_MAX ] = { };
bool        CDebugFont::centerRender = false;



// CDebugFont constructor
CDebugFont::CDebugFont( )
{

	// Member Initialize
	pFont = nullptr;
	color = D3DXCOLOR( 1, 1, 1, 1 );
	char data[ STRING_MAX ] = { };
	strcpy( lData, data );
	strcpy( rData, data );
	strcpy( cData, data );

	// Registration Class( Texture Renderer )
	for( int index = 0; index < CDF_MAX; index++ ){
		if( pDebugFont[index] == NULL ){
			pDebugFont[index] = this;
			myNumber = index;
			break;
		}
	}


}

// CDebugFont destructor
CDebugFont::~CDebugFont( )
{

    // Do Nothing!!

}

// CDebugFont SetDebugFont Setting
CDebugFont* CDebugFont::SetDebugFont( void )
{

	
	// Create Class Instance
	CDebugFont* pObject;
	pObject = new CDebugFont;
	
	// Take Device Pointer
	Renderer* pRenderer= GameManager::Operate( )->DeviceInfo( );
	LPDIRECT3DDEVICE9 pDevice =  dynamic_cast< RendererDX9* >(pRenderer)->GetDevice( );
	
	// Initialize Font Interface !!
	D3DXCreateFont( pDevice,18,0,0,0,FALSE,
		SHIFTJIS_CHARSET,
		OUT_DEFAULT_PRECIS,
		DEFAULT_QUALITY,
		DEFAULT_PITCH,
		"terminal",&pObject->pFont );

	return pObject;

	
}

// CDebugFont Get Pointer : Index Access
CDebugFont* CDebugFont::Access( const int index )
{

	return pDebugFont[ index ];

}

// CDebugFont Render Data Set
void CDebugFont::SetRenderData( DF_RENDER_POS renderType, char* data, ... )
{

	va_list ap;
	char buf[ 256 ];

	// String data Copy Process
	va_start( ap, data );
	vsprintf( buf, data, ap );
	va_end( ap );

	// rendaring Position Setting
	if( renderType == L_RENDER ){
	
		sprintf( lData, "%s%s", lData, buf );
	}
	else if( renderType == R_RENDER ){
	
		sprintf( rData, "%s%s", rData, buf );
	}
	else if( renderType == C_RENDER ){

		sprintf( cData, "%s%s", cData, buf );
	}

}

// CDebugFont Data Render
void CDebugFont::Render( void )
{

	// Data Render Rect Size
	RECT rect={ 0,0,Window::SCREEN_WIDTH,Window::SCREEN_HEIGHT };

	{ // Render Debug Data :: 

		// Data Render Left
		pFont ->DrawText( NULL, &lData[0], -1, &rect, DT_LEFT, color );

		// Data Render Right
		pFont ->DrawText( NULL, &rData[0], -1, &rect, DT_RIGHT, color );

		// Data Render Center : default not Using
		if( centerRender ){
			pFont ->DrawText( NULL, &cData[0], -1, &rect, DT_CENTER | DT_VCENTER, color );
		}

	} // -> END : Render Debug Data

	Clear();

}

//
void CDebugFont::Clear(void)
{

	// String Delete
	strcpy( lData, "" );
	strcpy( rData, "" );
	strcpy( cData, "" );

}

// CDebugFont Class Release
CDebugFont* CDebugFont::Release( void )
{

	// CDebugFont Release
	SAFE_RELEASE( pFont )

	return this;

}

// CDebugFont Set Font Color
void CDebugFont::SetColor( const LPD3DXCOLOR color )
{
	
	// Setting Color Info
	CDebugFont::color = *color;

}

// CDebugFont Release Class All
void CDebugFont::ReleaseAll( void )
{

	// Release CDebugFont All
	for( int index = 0; index < CDF_MAX; index ++ ){

		if( pDebugFont[ index ] ){
		
			pDebugFont[ index ] ->Release( );
			SAFE_DELETE( pDebugFont[ index ] )
		}
	}


}

// CDebugFont Draw Class All
void CDebugFont::DrawAll( void )
{

	//  Draw CDebugFont All
	for( int index = 0; index < CDF_MAX; index ++ ){

		if( pDebugFont[ index ] != NULL ){
		
			pDebugFont[ index ] ->Render( );
		}
	}

}

// CDebugFont Render Center Flag Switch
void CDebugFont::DebugCenterRender( const bool flag )
{

	// Setting bool 
	centerRender = flag;

}


