/***************************************************************/
//
//
//		DirectX	[ event.h ]
//
//											Author	kazuki tanaka
//											Date	2017 2/06
/*---------------------------------------------------------------
Update : 2017/1/31
			Create Header File -> event.h
			

Update : 2016/1/31



/*-------------------------------------------------------------*/
#ifndef _EVENT_H_

#define _EVENT_H_


/*---------------------------------------------------------------
 	Macro Definition
---------------------------------------------------------------*/

#define MAX_EVENT  (16)							// Class Event Max Number
#define STRING_MAX (32)							// Font Data Max Number

/*---------------------------------------------------------------
	Class CEvent for Screen Render Debug Font
---------------------------------------------------------------*/

// For Event Process , Base Event Class. Using Call Back Event Process
class CEvent
{	
public:

	CEvent( );									// CEvent constructor
	~CEvent( );									// CEvent destructor
	
	static void ReleaseAll( void );				// CEvent Release Class All
	static void CallbackUpdate( void );			// CEvent Update Class All
	static void CallbackDraw( void );			// CEvent Draw Class All

	static bool CallbackEvent( 					// CEvent Callback Setting Do Event
		const char* EVENT_NAME );
	
	static bool EventsState( void );			// CEvent Events True Or False
	
	virtual void Init( void )   = 0;			// @Inheritance Call Back Function( Initialize)
	virtual void Uninit( void ) = 0;			// @Inheritance Call Back Function( Completed )
	virtual void Update( void ) = 0;			// @Inheritance Call Back Function( Update )
	virtual void Draw( void )   = 0;			// @Inheritance Call Back Function( Draw )

private:

	char       eventName[STRING_MAX];			// Class Event Name, Need Call Back
	int        myNumber;						// Class ID : My Number 
	
	static CEvent* pEvent[ MAX_EVENT ];			// Class Registry Event Process
	static bool events;							// Events Flag
	static int  callbackIndex;					// Callback Event Index Number
	
// inline Process
public:
	
	static inline void CallbackEvent( const int index ){
	
		// Index Call back Index Process
		callbackIndex = index;
		events = true;
	}
protected:
	
	// if event completed, must callback this Process
	inline void EventEnd( void ){
	
		events = false;		// if dont callback this Process, never finished Event Process
	}

	// Setting Event Name
	void SetEventName( const char* EVENT_NAME );
	
};




#endif	//	_EVENT_H_


