/***************************************************************/
//
//
//		DirectX	[ fade.cpp ]
//
//											Author	kazuki tanaka
//											Date	2017 6/19
/*---------------------------------------------------------------
Update : 2017/6/19
			fade.cpp̍쐬

/*---------------------------------------------------------------
	Include File
---------------------------------------------------------------*/


#include "fade.h"

#include "sprite.h"


/*---------------------------------------------------------------
	Macro Difinition
---------------------------------------------------------------*/

#define FADE_RATE(s) ( 1.0f /(60 * s) )				// tF[h[g
#define FADE_SECONDS ( 1.6f )						// tF[h:P(b/s)

/*----------------------------------------------------------------
	static member variable Initialize 
----------------------------------------------------------------*/





// Fade Constructor
Fade::Fade( )
	: sprite(nullptr)
	, color(0,0,0,1)
{

	// Menber Clear Process

}

// Fade Destructor
Fade::~Fade( )
{

	// Do Nothing!!

}

// Fade Initialize
void Fade::Init( void )
{

	// Initialize Process
	sprite = Sprite::Create("data\\texture\\fade000.png");
	sprite->Init();

}

// Fade Uninitialize
void Fade::Uninit( void )
{

	// Uninitialize Process
	sprite->Uninit();

}

// Fade Update
void Fade::Update( void )
{

	// Update Process
	sprite->SetVertex( color );

}

// Fade DoTransition
void Fade::DoTransition( void )
{
	
	color.a += FADE_RATE( FADE_SECONDS );

	if( color.a > 1.0f ){

		color.a = 1.0f;
		SwapEffect::DoTransition();

	}
	
}

// Fade Switch
bool Fade::Switch( void )
{
	SwapEffect::Switch();
	return true;
}

// Fade TransitionEnd
void Fade::TransitionEnd( void )
{

	color.a -= FADE_RATE( FADE_SECONDS );

	if( color.a < 0.0f ){

		color.a = 0.0f;
		SwapEffect::TransitionEnd();
	}

}





