/***************************************************************/
//
//
//		DirectX	[game_background.cpp]
//
//										Author	kazuki tanaka
//										Date	2016 08/26
/*---------------------------------------------------------------
Update : 2016/08/26

/*---------------------------------------------------------------
	CN[ht@C
---------------------------------------------------------------*/
#include "main.h"

#include "game_background.h"
#include "window.h"
#include "rendererdx9.h"

/*---------------------------------------------------------------
	}N`
---------------------------------------------------------------*/
/*---------------------------------------------------------------
	萔`
---------------------------------------------------------------*/

#define TEXTURE_NAME  "data/TEXTURE/shine000.jpg"		// eNX`l[

#define NUM_VERTEX          ( 4 )						// _

#define VTXMAX_GAMEBG		( 80 )						// ő咸_
#define START_COORD_X		( 0 )						// wiʒuX
#define START_COORD_Y		( 0 )						// wiʒuY
#define END_COORD_X      	( 256 )						// wĩ|STCY{X
#define END_COORD_Y	        ( 256 )						// wĩ|STCY{Y

#define COLOR_R				( 255 )						// |SԐF
#define COLOR_G				( 255 )						// |SΐF
#define COLOR_B				( 255 )						// |SF
#define COLOR_A				( 10 )						// |Sl

/*---------------------------------------------------------------
	Tu[`
---------------------------------------------------------------*/

// _W̐ݒ
void SetVertexGameBackground( void );

/*---------------------------------------------------------------
	O[oϐ
---------------------------------------------------------------*/

LPDIRECT3DVERTEXBUFFER9 g_pVtxBuffTitleBg = nullptr;	// _obt@w̃|C^
LPDIRECT3DTEXTURE9		g_pTextureTitleBg = nullptr;	// eNX`ւ̃|C^

D3DXVECTOR3				g_posTitleBg;					// |S̒SW
D3DXVECTOR3				g_rotTitleBg;					// |S̉]pxp(ΓIɑZl)
D3DXVECTOR3				g_moveTitleBg;					// ړ(x)

float g_fDiagonalGamebackground = 0.0f;							// Ίp̒
float g_fAngleGamebackground    = 0.0f;							// Ίp̊px

int g_nCntAnimGamebackground     = 0;							// Aj[VJE^
int g_nPatternAnimGamebackground = 0;							// Aj[Vp^[


// Q[wȉ
void InitGameBackground( void )
{


	LPDIRECT3DDEVICE9 pDevice = GetDevice( );			// foCX̎擾


	{ //O[oϐ

		g_fDiagonalGamebackground = sqrtf( (END_COORD_X/2)*(END_COORD_X/2) + (END_COORD_Y/2) * (END_COORD_Y/2) );
		g_fAngleGamebackground    = atan2f( END_COORD_X/2 , END_COORD_Y/2 );

		g_posTitleBg = D3DXVECTOR3( Window::SCREEN_WIDTH >> 1, Window::SCREEN_HEIGHT >> 1, 0.0f );

		g_moveTitleBg = D3DXVECTOR3( 0.0f , 0.0f , 0.0f);

		// ZWlgȂB0ȊOĂ΁AԂŌXĕ\
		g_rotTitleBg = D3DXVECTOR3( 0.0f,
								   0.0f,
								   0.0f);

		// Aj[V֘A̕ϐ
		g_nCntAnimGamebackground = 0;
		g_nPatternAnimGamebackground = 0;
	
	} // -> END


	// _obt@̊m
	pDevice -> CreateVertexBuffer( sizeof( VERTEX_2D ) * VTXMAX_GAMEBG,		// mۃobt@̑傫
									  D3DUSAGE_WRITEONLY ,					// _obt@gp@
									  FVF_VERTEX_2D ,						// _tH[}bg
									  D3DPOOL_MANAGED,						// obt@ێ郁NX
									  &g_pVtxBuffTitleBg,
									  NULL );

	{ // _̐ݒ

		// _bN
		VERTEX_2D *pVtx;
		g_pVtxBuffTitleBg -> Lock( 0 , 0 , (void**)&pVtx , 0 );


		// _Wݒ
		for( int nCnt = 0 ; nCnt < VTXMAX_GAMEBG ; nCnt+=4 ){

			pVtx[nCnt].pos = D3DXVECTOR3( g_posTitleBg.x + ( sinf( D3DX_PI + g_fAngleGamebackground + g_rotTitleBg.z * (nCnt+1) * 0.03 ) * (g_fDiagonalGamebackground + ( nCnt * 10 ) )),
									   g_posTitleBg.y + ( cosf( D3DX_PI + g_fAngleGamebackground + g_rotTitleBg.z * (nCnt+1) * 0.03) * (g_fDiagonalGamebackground + ( nCnt * 10 )) ) ,
									   0.0f );
			pVtx[nCnt + 1].pos = D3DXVECTOR3( g_posTitleBg.x + ( sinf( D3DX_PI - g_fAngleGamebackground + g_rotTitleBg.z* (nCnt+1) * 0.04 ) * (g_fDiagonalGamebackground+ ( nCnt * 10 ) ) ) ,
									   g_posTitleBg.y + ( cosf( D3DX_PI - g_fAngleGamebackground + g_rotTitleBg.z* (nCnt+1) * 0.03 ) * (g_fDiagonalGamebackground + ( nCnt * 10 ))) ,
									   0.0f );
			pVtx[nCnt + 2].pos = D3DXVECTOR3( g_posTitleBg.x + ( sinf( 0 - g_fAngleGamebackground + g_rotTitleBg.z* (nCnt+1) * 0.01 ) * (g_fDiagonalGamebackground + ( nCnt * 10 ) )) ,
									   g_posTitleBg.y + ( cosf( 0 - g_fAngleGamebackground + g_rotTitleBg.z* (nCnt+1) * 0.03 ) *(g_fDiagonalGamebackground + ( nCnt * 10 ))) ,
									   0.0f );
			pVtx[nCnt + 3].pos = D3DXVECTOR3( g_posTitleBg.x + ( sinf( g_fAngleGamebackground + g_rotTitleBg.z * (nCnt+1) * 0.02) * (g_fDiagonalGamebackground + ( nCnt * 10 )) ) ,
									   g_posTitleBg.y + ( cosf( g_fAngleGamebackground + g_rotTitleBg.z * (nCnt+1) * 0.03) * (g_fDiagonalGamebackground+ ( nCnt * 10 ) )) ,
									   0.0f);
		}

		// _J[ݒ
		for( int nCnt = 0 ; nCnt < VTXMAX_GAMEBG ; nCnt+=4 )
		{
			pVtx[nCnt  ].color = D3DCOLOR_RGBA( COLOR_R , COLOR_G , COLOR_B , COLOR_A );
			pVtx[nCnt+1].color = D3DCOLOR_RGBA( COLOR_R , COLOR_G , COLOR_B , COLOR_A );
			pVtx[nCnt+2].color = D3DCOLOR_RGBA( COLOR_R , COLOR_G , COLOR_B , COLOR_A );
			pVtx[nCnt+3].color = D3DCOLOR_RGBA( COLOR_R , COLOR_G , COLOR_B , COLOR_A );
		}

		// eNX`Wݒ
		for( int nCnt = 0 ; nCnt < VTXMAX_GAMEBG ; nCnt+=4 )
		{
			pVtx[nCnt  ].tex = D3DXVECTOR2( 0.0 , 0.0 );	//eNX`W
			pVtx[nCnt+1].tex = D3DXVECTOR2( 1.0 , 0.0 );
			pVtx[nCnt+2].tex = D3DXVECTOR2( 0.0 , 1.0 );
			pVtx[nCnt+3].tex = D3DXVECTOR2( 1.0 , 1.0 );
		}

		// 1.0fŒ,ςKvȂ
		for( int nCnt = 0 ; nCnt < VTXMAX_GAMEBG ; nCnt+=4 )
		{
			pVtx[nCnt].rhw = 1.0f;
			pVtx[nCnt+1].rhw = 1.0f;
			pVtx[nCnt+2].rhw = 1.0f;
			pVtx[nCnt+3].rhw = 1.0f;
		}
	
	} // -> END


	// _AbN
	g_pVtxBuffTitleBg -> Unlock();


	// eNX`̓ǂݍ
	if( FAILED( D3DXCreateTextureFromFile( pDevice , TEXTURE_NAME , &g_pTextureTitleBg )))
	{
		MessageBox( NULL , "eNX`Ǎs" , "G[" , MB_YESNO | MB_ICONQUESTION );
	}


}

// Q[wȉI
void UninitGameBackground( void )
{

	//_obt@̉
	SAFE_RELEASE( g_pVtxBuffTitleBg  )


	//eNX`̉(vC[)
	SAFE_RELEASE( g_pTextureTitleBg )


}

// Q[wi̍XV
void UpdateGameBackground( void )
{

	// ]Aj[V̍XV
	g_rotTitleBg.z -= ( D3DX_PI * 0.001f );

	// _W̍XV
	SetVertexGameBackground( );

}

// Q[wi̕`揈
void DrawGameBackground( void )
{


	// foCX̎擾
	LPDIRECT3DDEVICE9 pDevice = GetDevice( );

	// Z̐ݒ
	pDevice -> SetRenderState( D3DRS_BLENDOP , D3DBLENDOP_ADD );
	pDevice -> SetRenderState( D3DRS_SRCBLEND , D3DBLEND_SRCALPHA );
	pDevice -> SetRenderState( D3DRS_DESTBLEND , D3DBLEND_ONE );


	// _obt@f[^Xg[ɃoCh
	pDevice -> SetStreamSource( 0 , g_pVtxBuffTitleBg , 0 , sizeof( VERTEX_2D ) );

	// _tH[}bgݒ
	pDevice -> SetFVF( FVF_VERTEX_2D );

	// |S`
	for( int nCnt = 0 ; nCnt < VTXMAX_GAMEBG ; nCnt+=4 )
	{

		// eNX`ݒ
		pDevice -> SetTexture( 0 , g_pTextureTitleBg );

		// |S`
		pDevice -> DrawPrimitive( D3DPT_TRIANGLESTRIP , nCnt , 2 );

	}

	// ̏Ԃɖ߂
	pDevice->SetRenderState( D3DRS_ALPHABLENDENABLE,TRUE );				//
	pDevice->SetRenderState( D3DRS_SRCBLEND, D3DBLEND_SRCALPHA );		//̃
	pDevice->SetRenderState( D3DRS_DESTBLEND,D3DBLEND_INVSRCALPHA );		//̃

}

// _W̍XV
void SetVertexGameBackground( void )
{

	//_bN
	VERTEX_2D *pVtx;
	g_pVtxBuffTitleBg -> Lock( 0 , 0 , (void**)&pVtx , 0 );

	//_Wݒ---------------------------------------------------------

		for( int nCnt = 0 ; nCnt < VTXMAX_GAMEBG ; nCnt+=4 )
		{

			pVtx[nCnt].pos = D3DXVECTOR3( g_posTitleBg.x + ( sinf( D3DX_PI + g_fAngleGamebackground + g_rotTitleBg.z * (nCnt+1) * 0.03 ) * (g_fDiagonalGamebackground + ( nCnt * 10 ) )),
									   g_posTitleBg.y + ( cosf( D3DX_PI + g_fAngleGamebackground + g_rotTitleBg.z * (nCnt+1) * 0.04) * (g_fDiagonalGamebackground + ( nCnt * 10 )) ) ,
									   0.0f );
			pVtx[nCnt + 1].pos = D3DXVECTOR3( g_posTitleBg.x + ( sinf( D3DX_PI - g_fAngleGamebackground + g_rotTitleBg.z* (nCnt+1) * 0.04 ) * (g_fDiagonalGamebackground+ ( nCnt * 10 ) ) ) ,
									   g_posTitleBg.y + ( cosf( D3DX_PI - g_fAngleGamebackground + g_rotTitleBg.z* (nCnt+1) * 0.04 ) * (g_fDiagonalGamebackground + ( nCnt * 10 ))) ,
									   0.0f );
			pVtx[nCnt + 2].pos = D3DXVECTOR3( g_posTitleBg.x + ( sinf( 0 - g_fAngleGamebackground + g_rotTitleBg.z* (nCnt+1) * 0.01 ) * (g_fDiagonalGamebackground + ( nCnt * 10 ) )) ,
									   g_posTitleBg.y + ( cosf( 0 - g_fAngleGamebackground + g_rotTitleBg.z* (nCnt+1) * 0.04 ) *(g_fDiagonalGamebackground + ( nCnt * 10 ))) ,
									   0.0f );
			pVtx[nCnt + 3].pos = D3DXVECTOR3( g_posTitleBg.x + ( sinf( g_fAngleGamebackground + g_rotTitleBg.z * (nCnt+1) * 0.02) * (g_fDiagonalGamebackground + ( nCnt * 10 )) ) ,
									   g_posTitleBg.y + ( cosf( g_fAngleGamebackground + g_rotTitleBg.z * (nCnt+1) * 0.04) * (g_fDiagonalGamebackground+ ( nCnt * 10 ) )) ,
									   0.0f);

		}

		//---------------------------------------------------------------------

	//_AbN
	g_pVtxBuffTitleBg -> Unlock();
}


