/***************************************************************/
//
//
//		DirectX	[ gamepad.cpp ]
//
//											Author	kazuki tanaka
//											Date	2016 11/21
/*---------------------------------------------------------------
Update : 2016/11/21
			gamepad.cpp̍쐬

/*---------------------------------------------------------------
	Include File
---------------------------------------------------------------*/

#include "gamepad.h"

#ifdef _DEBUG
#include <stdio.h>
#endif	// _DEGUG

/*---------------------------------------------------------------
	}N`
---------------------------------------------------------------*/

#define	LIMIT_COUNT_REPEAT	( 5 )		// s[gJEg~b^[

/*---------------------------------------------------------------
	X^eBbNoϐ̏
---------------------------------------------------------------*/



// CInputGamepadRXgX^
CInputGamepad::CInputGamepad( )
	: CInput( CInput::TYPE_JOYPAD )
{

	// e[ÑNA
	ZeroMemory( &dijs,           sizeof dijs );
	ZeroMemory( &setDijs,        sizeof dijs );
	ZeroMemory( &dijsTrig,       sizeof dijs );
	ZeroMemory( stateTrigger,   sizeof (BYTE)*PAD_KEY_MAX );
	ZeroMemory( stateRelease,   sizeof (BYTE)*PAD_KEY_MAX );
	ZeroMemory( stateRepeat,    sizeof (BYTE)*PAD_KEY_MAX );
	ZeroMemory( stateRepeatCnt, sizeof (int)*PAD_KEY_MAX );

}

// CInputGamepadfXgX^
CInputGamepad::~CInputGamepad( )
{

	// Do Nothing!!

}

// CInputGamepad Create Instance 
CInputGamepad* CInputGamepad::Create( void )
{
	
	// Create Class Instance
	CInputGamepad* pObject;
	pObject = new CInputGamepad;
	
	return pObject;
	
}

// WCXeBbN̏
HRESULT CInputGamepad::Init( HINSTANCE hInstance, HWND hWnd )
{

	HRESULT hr;

	// ͏̏
	if(FAILED( CInput::Init( hInstance, hWnd ) ))
	{
		#ifdef _DEBUG
		MessageBox(hWnd, "DirectInputIuWFNg쐬o܂łI", "xI", MB_ICONWARNING);
		#endif	// _DEBUG
		return E_FAIL;
	}

	// foCXIuWFNg쐬
	hr = CInput::pDirectInput->CreateDevice(GUID_Joystick, &pInputDevice, NULL);
	if(FAILED(hr) || pInputDevice == NULL)
	{
		MessageBox(hWnd, "WCXeBbN˂I", "xI", MB_ICONWARNING);
		return hr;
	}

	// f[^tH[}bgݒ
	hr = pInputDevice->SetDataFormat(&c_dfDIJoystick2);
	if(FAILED(hr))
	{
		MessageBox(hWnd, "WCXeBbÑf[^tH[}bgݒł܂łB", "xI", MB_ICONWARNING);
		return hr;
	}

	// [hݒitHAOEhr[hj
	hr = pInputDevice->SetCooperativeLevel(hWnd, (DISCL_FOREGROUND | DISCL_NONEXCLUSIVE));
	if(FAILED(hr))
	{
		MessageBox(hWnd, "WCXeBbN̋[hݒł܂łB", "xI", MB_ICONWARNING);
		return hr;
	}

	// pInputDeviceANZXl(͐Jn)
	if( FAILED( pInputDevice ->Poll( ) ) )
	{
		pInputDevice->Acquire( );		
	}

	// foCXf[^擾
	hr =  pInputDevice ->GetDeviceState( sizeof( DIJOYSTATE2 ), &dijs );
	if( SUCCEEDED( hr )){

		// l̏
		setDijs = dijs;
	}

	return hr;

}

// WCXeBbN͏̊J
void CInputGamepad::Uninit( void )
{
	// ͏̊J
	CInput::Uninit();
}

// WCXeBbN̍XV
void CInputGamepad::Update( void )
{

	if(!pInputDevice)
	{
		return;
	}

	DIJOYSTATE2 currentDijs = { };


	// foCXf[^擾
	if(SUCCEEDED( pInputDevice->GetDeviceState(sizeof(DIJOYSTATE2), &currentDijs )))
	{

		// l̏
		//currentDijs.lX -= setDijs.lX;
		//currentDijs.lY -= setDijs.lY;
		//currentDijs.lZ -= setDijs.lZ;

		for(int nCnKey = 0; nCnKey < PAD_KEY_MAX; nCnKey++)
		{
			
			// L[gK[[X̍쐬
			stateTrigger[nCnKey]=( dijs.rgbButtons[nCnKey] ^ currentDijs.rgbButtons[nCnKey]) & currentDijs.rgbButtons[nCnKey];

			stateRelease[nCnKey]=( dijs.rgbButtons[nCnKey] ^ currentDijs.rgbButtons[nCnKey]) & dijs.rgbButtons[nCnKey];

			// L[s[g̐
			if( currentDijs.rgbButtons[nCnKey] & 0x80 ){			//sNꍇ, if( dijs.rgbButtons[nCnKey] & 0x80 )
				if( stateRepeatCnt[nCnKey] < LIMIT_COUNT_REPEAT){
					stateRepeatCnt[nCnKey]++;
					if( stateRepeatCnt[nCnKey]==1){
					//if( g_dijsRepeatCnt[nCnKey]==1 || g_dijsRepeatCnt[nCnKey]>=LIMIT_COUNT_REPEAT ){

						stateRepeat[nCnKey]=currentDijs.rgbButtons[nCnKey];
		
					}
					else{
						
						stateRepeat[nCnKey] = 0 ;

					}
				}
			}
			else{
			
				stateRepeat[nCnKey]=0;
				stateRepeatCnt[nCnKey]=0;

			}

			// L[vXۑ
			//g_dijs.rgbButtons[nCnKey] = dijs.rgbButtons[nCnKey];

		}

		// L[gK[̎擾
		dijsTrig.lX = ( dijs.lX ^ currentDijs.lX ) & currentDijs.lX;
		dijsTrig.lY = ( dijs.lY ^ currentDijs.lY ) & currentDijs.lY;
		dijsTrig.lZ = ( dijs.lZ ^ currentDijs.lZ ) & currentDijs.lZ;

		// L[vXۑ
		dijs = currentDijs;

	}
	else{
		// Q[pbhւ̃ANZX擾
		pInputDevice ->Acquire( );
	}

}

// WCXeBbNf[^擾(vX)
bool CInputGamepad::GetKeyPress(int nKey)
{
	return ( dijs.rgbButtons[ nKey ] & 0x80) ? TRUE: FALSE;
}

// WCXeBbNf[^擾(gK[)
bool CInputGamepad::GetKeyTrigger(int nKey)
{
	return (stateTrigger[nKey] & 0x80) ? TRUE: FALSE;
}

// WCXeBbNf[^擾([X)
bool CInputGamepad::GetKeyRelease(int nKey)
{
	return (stateRelease[nKey] & 0x80) ? TRUE: FALSE;
}

// WCXeBbNf[^擾(s[g)
bool CInputGamepad::GetKeyRepeat(int nKey)
{
	return (stateRepeat[nKey] & 0x80) ? TRUE: FALSE;
}

// WCXeBbNf[^폜(gK[)
void CInputGamepad::FlushKeyTrigger(int nKey)
{
	stateTrigger[nKey] = 0;
}

// WCXeBbN{^̎擾
bool CInputGamepad::GetGamepadUp( void )
{
	return ( dijs.lY < 0 ) ? true: false; 
}

// WCXeBbN{^̎擾
bool CInputGamepad::GetGamepadDown( void )
{
	return ( dijs.lY > 0 ) ? true: false; 
}

// WCXeBbN{^̎擾
bool CInputGamepad::GetGamepadLeft( void )
{
	return ( dijs.lX < 0 ) ? true: false; 
}

// WCXeBbN{^̎擾
bool CInputGamepad::GetGamepadRight( void )
{
	return ( dijs.lX > 0 ) ? true: false; 
}

// WCXeBbN{^̎擾
bool CInputGamepad::GetGamepadUpTrigger( void )
{
	return ( dijsTrig.lY < 0 ) ? true: false; 
}

// WCXeBbN{^̎擾
bool CInputGamepad::GetGamepadDownTrigger( void )
{
	return ( dijsTrig.lY > 0 ) ? true: false; 
}

// WCXeBbN{^̎擾
bool CInputGamepad::GetGamepadLeftTrigger( void )
{
	return ( dijsTrig.lX < 0 ) ? true: false; 
}

// WCXeBbN{^̎擾
bool CInputGamepad::GetGamepadRightTrigger( void )
{
	return ( dijsTrig.lX > 0 ) ? true: false; 
}



