/***************************************************************/
//
//
//		DirectX	[ gamepad.cpp ]
//
//											Author	kazuki tanaka
//											Date	2016 11/28
/*---------------------------------------------------------------
Update : 2016/11/28
			gamepad.h̍쐬

/*-------------------------------------------------------------*/
#ifndef _GAMEPAD_H_

#define _GAMEPAD_H_

#include "input.h"

/*---------------------------------------------------------------
	}N`
---------------------------------------------------------------*/
#define	PAD_KEY_MAX		( 128 )							// L[̍ő吔


// Q[pbh̓NX
class CInputGamepad : public CInput
{
public:

	// WCXeBbN{^zl( PS3z )
	typedef enum{

		GP_BUTTON_TRIANGLE = 0,							// {^
		GP_BUTTON_CIRCLE,								// Z{^
		GP_BUTTON_CROSS,								// ~{^
		GP_BUTTON_SQUARE,								// {^
		GP_BUTTON_L1,									// L1{^
		GP_BUTTON_R1,									// R1{^
		GP_BUTTON_L2,									// L2{^
		GP_BUTTON_R2,									// R2{^
		GP_BUTTON_SELECT,								// SELECT{^
		GP_BUTTON_START,								// START{^
		GP_BUTTON_L_STHICK,								// STHICK{^
		GP_BUTTON_R_STHICK,								// ESTHICK{^
		GP_BUTTON_POWER									// POWER{^

	}STATE;

	CInputGamepad( );
	~CInputGamepad( );

	static CInputGamepad* Create( void );				// CMouse Create Instance Class

	HRESULT Init( HINSTANCE hInstance, HWND hWnd );
	void Uninit(void);
	void Update(void);

	bool GetKeyPress(int nKey);
	bool GetKeyTrigger(int nKey);
	bool GetKeyRelease(int nKey);
	bool GetKeyRepeat(int nKey);
	void FlushKeyTrigger(int nKey);

	bool GetGamepadUp( void );
	bool GetGamepadDown( void );
	bool GetGamepadLeft( void );
	bool GetGamepadRight( void );

	bool GetGamepadUpTrigger( void );
	bool GetGamepadDownTrigger( void );
	bool GetGamepadLeftTrigger( void );
	bool GetGamepadRightTrigger( void );

private:

	DIJOYSTATE2				dijs;						// Q[pbh̏
	DIJOYSTATE2				setDijs;					// Q[pbh̏lۑp
	DIJOYSTATE2				dijsTrig;					// Q[pbh̓{^gK[(\Ȃ)

	BYTE	stateTrigger[PAD_KEY_MAX];					// gK[[N
	BYTE	stateRelease[PAD_KEY_MAX];					// [X[N
	BYTE	stateRepeat[PAD_KEY_MAX];					// s[g[N
	int     stateRepeatCnt[PAD_KEY_MAX];				// s[gJE^
		
};


#endif	// _GAMEPAD_H_


