/***************************************************************/
//
//
//		DirectX	[ indexbufferdx9.cpp ]
//
//											Author	kazuki tanaka
//											Date	2017 5/23
/*---------------------------------------------------------------
Update : 2017/5/23
			indexbufferdx9.cpp̍쐬

/*---------------------------------------------------------------
	Include File
---------------------------------------------------------------*/


#include "indexbufferdx9.h"


/*---------------------------------------------------------------
	Macro Difinition
---------------------------------------------------------------*/



/*---------------------------------------------------------------
	Const Number Difinition
---------------------------------------------------------------*/


/*----------------------------------------------------------------
	static member variable Initialize 
----------------------------------------------------------------*/





// IndexBufferDX9 Constructor
IndexBufferDX9::IndexBufferDX9( )
	: pIdxBuf(nullptr)
{

	// Menber Clear Process

}

// IndexBufferDX9 Destructor
IndexBufferDX9::~IndexBufferDX9( )
{

	// Do Nothing!!

}

// IndexBufferDX9 Create Instance 
IndexBufferDX9* IndexBufferDX9::Create( void )
{

	// Create Class Instance
	IndexBufferDX9* pObject;
	pObject = new IndexBufferDX9;

	return pObject;

}

// IndexBufferDX9 Initialize
bool IndexBufferDX9::CreateIndexBuffer( unsigned int indexNumber )
{
	

	LPDIRECT3DDEVICE9 pDevice = GetDevice( );

	// Create Vertex Process
	if( FAILED( pDevice ->CreateIndexBuffer(
			sizeof( WORD ) * indexNumber,				// mۂobt@TCY(_m) P:oCg
			D3DUSAGE_WRITEONLY,							// gp@
			D3DFMT_INDEX16,								// gp钸_tH[}bg
			D3DPOOL_MANAGED,							// obt@̊Ǘ@
			&pIdxBuf,									// i[|C^
			NULL )))
	{
		#ifdef _DEBUG
		MessageBox( NULL, "Indexւ݂̏Ɏs܂!!", "Index Buffer ERROR !!", MB_OK | MB_ICONWARNING );
		#endif	// _DEBUG

		return false;
	}

	// Registry Setting
	IndexBufferDX9::indexNumber = indexNumber;
	
	
	return true;

}

// IndexbufferDX9 Uninitialize
void IndexBufferDX9::Release( void )
{

	// Uninitialize Process
	SAFE_RELEASE( pIdxBuf )
	delete this;

}

// IndexbufferDX9 SetFVF
void IndexBufferDX9::SetIndex( void )
{

	LPDIRECT3DDEVICE9 pDevice = GetDevice( );

	// Set FVF format
	pDevice ->SetIndices( pIdxBuf );

}

// IndexbufferDX9 Update
void IndexBufferDX9::Lock( unsigned short** pIndex )
{

	// Get < virtual Pointer >
	(pIdxBuf) -> Lock( 0, 0, (void**)pIndex, 0 );


}

// IndexbufferDX9 Draw
void IndexBufferDX9::Unlock( void )
{

	// Unlock Buffer
	(pIdxBuf) ->Unlock( );

}

