/***************************************************************/
//
//
//		DirectX	[ input.h ]
//
//											Author	kazuki tanaka
//											Date	2017 2/15
/*---------------------------------------------------------------
Update : 2017/2/15
			Create Header File -> input.h.h 
 			< Add Class Function >
				CInput->Constructor
				CInput->Destructor
				CInput->Create ( static member )
				CInput->Access ( static member )
				CInput->Init
				CInput->Uninit
				CInput->Update
				CInput->ReleaseAll ( static member )
				CInput->UpdateAll  ( static member )
				CInput->DrawAll    ( static member )

Update : 2017/2/15



/*-------------------------------------------------------------*/
#ifndef _INPUT_H_

#define _INPUT_H_

#define DIRECTINPUT_VERSION (0x0800)
#include <dinput.h>

#pragma comment (lib,"dxguid.lib")
#pragma comment (lib,"dinput8.lib")

#define INPUT_MAX (8)
#define STRING_MAX (16)

/*---------------------------------------------------------------
	class
---------------------------------------------------------------*/


// class CInput Using Input
class CInput
{
public:

	// Input Type
	typedef enum{
		TYPE_NONE = 0,
		TYPE_KEYBOARD,
		TYPE_MOUSE,
		TYPE_JOYPAD,
		TYPE_XINPUTGAMEPAD,
		TYPE_MAX,
	}TYPE;
	
	CInput( TYPE type );						// CInput constructor
	virtual ~CInput( );							// CInput destructor

	static CInput* Create( 						// CInput Create Instance Class
		const char* INPUT_NAME );
	static void ReleaseAll( void );				// CInput Class Release All 
	static CInput* Access(						// CInput Class Access Outside Function 
		const char* INPUT_NAME );

	virtual HRESULT Init(						// CInput Initialize
		HINSTANCE hInstance,
		HWND hWnd );
	virtual void Uninit( void );				// CInput Uninitialize
	virtual void Update( void );				// CInput Update

	virtual bool GetPress( const int& key );	// CInput Press
	virtual bool GetTrigger( const int& key );	// CInput Trigger
	virtual bool GetRelease( const int& key );	// CInput Release

	static void UpdateAll( void );				// CInput Update Class All

	void SetInputType( TYPE type );				// CInput SetInputDeviceType
	TYPE GetInputType( void );					// CInput GetInputDeviceType

private:

	// Input Member 
	int  myNumber;								// CInput MyNumber
	
	// static Member
	static CInput* pInput[ INPUT_MAX ];			// CInput Instance
	
protected:

	TYPE type;									// DeviceType
	
	LPDIRECTINPUTDEVICE8  pInputDevice;			// DeviceObject(NeedInput)
	static LPDIRECTINPUT8 pDirectInput;			// DirectInputObject

	char inputName[ STRING_MAX ];				// CInput Name


};


#endif	//	_INPUT_H_


