/***************************************************************/
//
//
//		DirectX	[ material.h ]
//
//											Author	kazuki tanaka
//											Date	2017 6/5
/*---------------------------------------------------------------
Update : 2017/6/5
			Create Header File -> material.h.h 
 			< Add Class Function >
				MATERIAL->Constructor
				MATERIAL->Destructor
				MATERIAL->Create ( static member )
				MATERIAL->Init
				MATERIAL->Uninit
				MATERIAL->Update
				MATERIAL->Draw

Update : 2017/6/5



/*-------------------------------------------------------------*/
#ifndef _MATERIAL_H_

#define _MATERIAL_H_


/*---------------------------------------------------------------
	Include File
---------------------------------------------------------------*/

#include "color.h"

/*---------------------------------------------------------------
	Class
---------------------------------------------------------------*/


// Class Material Using Material
class Material
{
public:
	
	Material( );								// Material Constructor
	~Material( );								// Material Destructor

	Material(									// Material Constructor
		const Color&, 
		const Color&, 
		const Color&,
		const Color&,
		const float );

	virtual Material GetStatus( void ){			// Meterial GetStatus
		return *this; }
	virtual void SetMaterial( void ) = 0;		// Meterial SetMaterial
	virtual void GetMaterial( void ) = 0;		// Meterial GetMaterial

public:

	// Member Variable
    Color   diffuse;     						// Diffuse color RGBA
    Color   ambient;      						// Ambient color RGB 
	Color   specular;     						// Specular 'shininess'
    Color   emissive;							// Emissive color RGB 
    float   power;								// Sharpness if specular highlight

};


#endif	//	_MATERIAL_H_


