/***************************************************************/
//
//
//		DirectX	[ meshrenderer.cpp ]
//
//											Author	kazuki tanaka
//											Date	2017 5/22
/*---------------------------------------------------------------
Update : 2017/5/22
			meshrenderer.cpp̍쐬

/*---------------------------------------------------------------
	Include File
---------------------------------------------------------------*/

#include "mesh_renderer.h"

#include "texture_interface.h"
#include "vertexbuffer.h"
#include "matrix.h"

#include "rendering_order.h"
#include "rendering_order_manager.h"

/*---------------------------------------------------------------
	Macro Difinition
---------------------------------------------------------------*/


/*---------------------------------------------------------------
	Const Number Difinition
---------------------------------------------------------------*/


/*----------------------------------------------------------------
	static member variable Initialize 
----------------------------------------------------------------*/





// MeshRenderer Constructor
MeshRenderer::MeshRenderer( VertexBuffer** ppVtxBuf, TextureInterface** ppTexture, Matrix* pMtx )
	: RenderInterface(3)
	, ppVtxBuf( ppVtxBuf )
	, ppTexture( ppTexture )
	, pMtx( pMtx )
{

	// Member Clear Process
	

}

// MeshRenderer Destructor
MeshRenderer::~MeshRenderer( )
{

	// Do Nothing!!

}

// MeshRenderer Create Instance 
MeshRenderer* MeshRenderer::SetComponent( VertexBuffer** ppVtxBuf, TextureInterface** ppTexture, Matrix* pMtx = nullptr )
{

	// Create Class Instance
	return new MeshRenderer( ppVtxBuf, ppTexture, pMtx );

}

// MeshRenderer Render
void MeshRenderer::Render( void )
{

	// Render Process	
	RenderingOrderManager::Operate( )->DrawPrimitiveStrip( *ppVtxBuf, *ppTexture, pMtx );

}






