/***************************************************************/
//
//
//		DirectX	[ meshrenderer.h ]
//
//											Author	kazuki tanaka
//											Date	2017 5/22
/*---------------------------------------------------------------
Update : 2017/5/22
			Create Header File -> meshrenderer.h.h 
 			< Add Class Function >
				MESHRENDERER->Constructor
				MESHRENDERER->Destructor
				MESHRENDERER->Create ( static member )
				MESHRENDERER->Init
				MESHRENDERER->Uninit
				MESHRENDERER->Update
				MESHRENDERER->Draw

Update : 2017/5/22



/*-------------------------------------------------------------*/
#ifndef _MESHRENDERER_H_

#define _MESHRENDERER_H_


/*---------------------------------------------------------------
	Include File
---------------------------------------------------------------*/

#include "render_Interface.h"

class VertexBuffer;
class TextureInterface;
class Matrix;

/*---------------------------------------------------------------
	Class
---------------------------------------------------------------*/


// Class MeshRenderer Using MeshRenderer
class MeshRenderer : public RenderInterface
{
public:
	
	MeshRenderer( 							// MeshRenderer constructor
		VertexBuffer** ppVtxBuf,
		TextureInterface** ppTexture,
		Matrix* pMtx );
	~MeshRenderer( );						// MeshRenderer destructor

	static MeshRenderer* SetComponent( 		// MeshRenderer Create Instance Class
		VertexBuffer** ppVtxBuf,
		TextureInterface** ppTexture,
		Matrix* pMtx );
	
	void Render( void );					// MeshRenderer Draw
	

private:

	// Member Variable
	VertexBuffer** ppVtxBuf;
	TextureInterface** ppTexture;
	Matrix* pMtx;
	

};


#endif	//	_MESHRENDERER_H_


