/***************************************************************/
//
//
//		DirectX	[ meshrenderer3duserinterface.h ]
//
//											Author	kazuki tanaka
//											Date	2017 6/19
/*---------------------------------------------------------------
Update : 2017/6/19
			Create Header File -> meshrenderer3duserinterface.h.h 
 			< Add Class Function >
				MeshRenderer3DUserInterface->Constructor
				MeshRenderer3DUserInterface->Destructor
				MeshRenderer3DUserInterface->Create ( static member )
				MeshRenderer3DUserInterface->Init
				MeshRenderer3DUserInterface->Uninit
				MeshRenderer3DUserInterface->Update
				MeshRenderer3DUserInterface->Draw

Update : 2017/6/19



/*-------------------------------------------------------------*/
#ifndef _MESHRENDERER3DUSERINTERFACE_H_

#define _MESHRENDERER3DUSERINTERFACE_H_


/*---------------------------------------------------------------
	Include File
---------------------------------------------------------------*/

#include "render_Interface.h"

class VertexBuffer;
class TextureInterface;
class Matrix;

/*---------------------------------------------------------------
	Class
---------------------------------------------------------------*/


// Class MeshRenderer3DUserInterface Using MeshRenderer3DUserInterface
class MeshRenderer3DUserInterface : public RenderInterface
{
public:
	
	MeshRenderer3DUserInterface( 							// MeshRenderer3DUserInterface constructor
		VertexBuffer** ppVtxBuf,
		TextureInterface** ppTexture,
		Matrix* pMtx,
		const int priority = 6 );
	~MeshRenderer3DUserInterface( );						// MeshRenderer3DUserInterface destructor

	static MeshRenderer3DUserInterface* SetComponent( 		// MeshRenderer3DUserInterface Create Instance Class
		VertexBuffer** ppVtxBuf,
		TextureInterface** ppTexture,
		Matrix* pMtx,
		const int priority = 5);
	
	void Render( void );					// MeshRenderer3DUserInterface Draw
	

private:

	// Member Variable
	VertexBuffer** ppVtxBuf;
	TextureInterface** ppTexture;
	Matrix* pMtx;
	

};


#endif	//	_MESHRENDERER3DUSERINTERFACE_H_


