/***************************************************************/
//
//
//		DirectX	[ meshrendererbillboard.cpp ]
//
//											Author	kazuki tanaka
//											Date	2017 6/19
/*---------------------------------------------------------------
Update : 2017/6/19
			meshrendererbillboard.cpp̍쐬

/*---------------------------------------------------------------
	Include File
---------------------------------------------------------------*/

#include "mesh_rendererbillboard.h"

#include "texture_interface.h"
#include "vertexbuffer.h"
#include "matrix.h"

#include "rendering_order.h"
#include "rendering_order_manager.h"

/*---------------------------------------------------------------
	Macro Difinition
---------------------------------------------------------------*/


/*----------------------------------------------------------------
	static member variable Initialize 
----------------------------------------------------------------*/





// MeshRendererBillboard Constructor
MeshRendererBillboard::MeshRendererBillboard( VertexBuffer** ppVtxBuf, TextureInterface** ppTexture, Matrix* pMtx )
	: RenderInterface(5)
	, ppVtxBuf( ppVtxBuf )
	, ppTexture( ppTexture )
	, pMtx( pMtx )
{

	// Member Clear Process
	

}

// MeshRendererBillboard Destructor
MeshRendererBillboard::~MeshRendererBillboard( )
{

	// Do Nothing!!

}

// MeshRendererBillboard Create Instance 
MeshRendererBillboard* MeshRendererBillboard::SetComponent( VertexBuffer** ppVtxBuf, TextureInterface** ppTexture, Matrix* pMtx = nullptr )
{

	// Create Class Instance
	return new MeshRendererBillboard( ppVtxBuf, ppTexture, pMtx );

}

// MeshRendererBillboard Render
void MeshRendererBillboard::Render( void )
{

	// Render Process	
	RenderingOrderManager::Operate( )->DrawBillboard( *ppVtxBuf, *ppTexture, pMtx );

}



