/***************************************************************/
//
//
//		DirectX	[ MeshRendererCullingOffcurringoff.cpp ]
//
//											Author	kazuki tanaka
//											Date	2017 6/20
/*---------------------------------------------------------------
Update : 2017/6/20
			MeshRendererCullingOffcurringoff.cpp̍쐬

/*---------------------------------------------------------------
	Include File
---------------------------------------------------------------*/

#include "mesh_renderercurringoff.h"
#include "mesh_renderer.h"

#include "texture_interface.h"
#include "vertexbuffer.h"
#include "matrix.h"

#include "rendering_order.h"
#include "rendering_order_manager.h"

/*---------------------------------------------------------------
	Macro Difinition
---------------------------------------------------------------*/


/*---------------------------------------------------------------
	Const Number Difinition
---------------------------------------------------------------*/


/*----------------------------------------------------------------
	static member variable Initialize 
----------------------------------------------------------------*/




// MeshRendererCullingOff Constructor
MeshRendererCullingOff::MeshRendererCullingOff( VertexBuffer** ppVtxBuf, TextureInterface** ppTexture, Matrix* pMtx )
	: RenderInterface(3)
	, ppVtxBuf( ppVtxBuf )
	, ppTexture( ppTexture )
	, pMtx( pMtx )
{

	// Member Clear Process
	

}

// MeshRendererCullingOff Destructor
MeshRendererCullingOff::~MeshRendererCullingOff( )
{

	// Do Nothing!!

}

// MeshRendererCullingOff Create Instance 
MeshRendererCullingOff* MeshRendererCullingOff::SetComponent( VertexBuffer** ppVtxBuf, TextureInterface** ppTexture, Matrix* pMtx = nullptr )
{

	// Create Class Instance
	return new MeshRendererCullingOff( ppVtxBuf, ppTexture, pMtx );

}

// MeshRendererCullingOff Render
void MeshRendererCullingOff::Render( void )
{

	// Render Process	
	RenderingOrderManager::Operate( )->DrawPrimitiveCurringOff( *ppVtxBuf, *ppTexture, pMtx );

}








