/***************************************************************/
//
//
//		DirectX	[ meshrendererinverse.h ]
//
//											Author	kazuki tanaka
//											Date	2017 6/20
/*---------------------------------------------------------------
Update : 2017/6/20
			Create Header File -> meshrendererinverse.h.h 
 			< Add Class Function >
				CMESHRENDERERINVERSE->Constructor
				CMESHRENDERERINVERSE->Destructor
				CMESHRENDERERINVERSE->Create ( static member )
				CMESHRENDERERINVERSE->Init
				CMESHRENDERERINVERSE->Uninit
				CMESHRENDERERINVERSE->Update
				CMESHRENDERERINVERSE->Draw

Update : 2017/6/20



/*-------------------------------------------------------------*/
#ifndef _MESHRENDERERINVERSE_H_

#define _MESHRENDERERINVERSE_H_

/*--------------------------------------------------------------
	Include File
---------------------------------------------------------------*/

#include "render_interface.h"

class VertexBuffer;
class IndexBuffer;
class TextureInterface;
class Matrix;

/*--------------------------------------------------------------
	Class
---------------------------------------------------------------*/


// Class MeshRendererInverse Using MeshRendererInverse
class MeshRendererInverse : public RenderInterface
{
public:
	
	MeshRendererInverse(								// MeshRendererInverse constructor
		VertexBuffer** ppVtxBuf,
		IndexBuffer** ppIdxBuf,
		TextureInterface** ppTexture,
		Matrix* pMtx );
	~MeshRendererInverse( );							// MeshRendererInverse destructor

	static MeshRendererInverse* SetComponent( 		// MeshRendererInverse Create Instance Class
		VertexBuffer** ppVtxBuf,
		IndexBuffer** ppIdxBuf,
		TextureInterface** ppTexture,
		Matrix* pMtx );	

	void Render( void );						// MeshRendererInverse Draw


private:

	// Member Variable
	VertexBuffer** ppVtxBuf;
	IndexBuffer**  ppIdxBuf;
	TextureInterface** ppTexture;
	Matrix* pMtx;

};


#endif	//	_MESHRENDERERINVERSE_H_


