/***************************************************************/
//
//
//		DirectX	[ MeshRendererSpriteEx.h ]
//
//											Author	kazuki tanaka
//											Date	2017 6/15
/*---------------------------------------------------------------
Update : 2017/6/15
			Create Header File -> MeshRendererSpriteEx.h.h 
 			< Add Class Function >
				MeshRendererSpriteEx->Constructor
				MeshRendererSpriteEx->Destructor
				MeshRendererSpriteEx->Create ( static member )
				MeshRendererSpriteEx->Init
				MeshRendererSpriteEx->Uninit
				MeshRendererSpriteEx->Update
				MeshRendererSpriteEx->Draw

Update : 2017/6/15



/*-------------------------------------------------------------*/
#ifndef _MeshRendererSpriteEx_H_

#define _MeshRendererSpriteEx_H_


/*---------------------------------------------------------------
	Include File
---------------------------------------------------------------*/

#include "sprite_interface.h"

class VertexBuffer;
class IndexBuffer;
class TextureInterface;

/*---------------------------------------------------------------
	Class
---------------------------------------------------------------*/


// Class MeshRendererSpriteEx Using MeshRendererSpriteEx
class MeshRendererSpriteEx : public SpriteInterface
{
public:
	
	MeshRendererSpriteEx(						// MeshRendererSpriteEx Constructor
		VertexBuffer** pVtxBuf,
		IndexBuffer** pIdxBuf,
		TextureInterface** pTexture,
		const int priority = 3 );	

	~MeshRendererSpriteEx( );					// MeshRendererSpriteEx Destructor

	static MeshRendererSpriteEx* SetComponent( 	// MeshRendererSpriteEx Create Instance Class
		VertexBuffer** pVtxBuf,
		IndexBuffer** pIdxBuf,
		TextureInterface** pTexture,
		const int priority = 3 );
	
	void Render( void );						// MeshRendererSpriteEx Render Sprite


private:

	// Member Variable
	VertexBuffer**     pVtxBuf;
	IndexBuffer**      pIdxBuf;
	TextureInterface** pTexture;

};


#endif	//	_MeshRendererSpriteEx_H_


