/***************************************************************/
//
//
//		DirectX	[ meshcube.cpp ]
//
//											Author	kazuki tanaka
//											Date	2017 6/19
/*---------------------------------------------------------------
Update : 2017/6/19
			meshcube.cpp̍쐬

/*---------------------------------------------------------------
	Include File
---------------------------------------------------------------*/

#include "meshcube.h"

#include "system_component.h"

#include "mesh_rendererlist.h"

#include "gameobject_manager.h"

#include "vertexbuffer_manager.h"
#include "texture_manager.h"

/*---------------------------------------------------------------
	Macro Difinition
---------------------------------------------------------------*/


/*---------------------------------------------------------------
	Const Number Difinition
---------------------------------------------------------------*/


/*----------------------------------------------------------------
	static member variable Initialize 
----------------------------------------------------------------*/





// MeshCube Constructor
MeshCube::MeshCube( const std::string& filename )
	: pVtxBuf(nullptr)
	, pTexture(nullptr)
	, renderer(nullptr)
	, color(1,1,1,1)
{

	// Member Clear Process
	pTexture = TextureManager::LoadFromManager( filename.data() );

}

// MeshCube Destructor
MeshCube::~MeshCube( )
{

	// Do Nothing!!

}

// MeshCube Create Instance 
MeshCube* MeshCube::Create( const std::string& filename )
{

	// Create Class Instance
	return new MeshCube( filename );

}

// MeshCube Initialize
void MeshCube::Init( void )
{

	// Initialize Process
	world.Identity(); 

	pVtxBuf = VertexBufferManager::PlatformSelect();
	if( !pVtxBuf->CreateVertexBuffer( FVF_VERTEX_3D, 6*6 ) ) return;

	// Set Buffer < Vertex & Index >
	SetBuffer( Vector3(20,20,20) );

	// Component Set
	renderer = MeshRendererList::SetComponent( &pVtxBuf, &pTexture, &world );

}

// MeshCube Uninitialize
void MeshCube::Uninit( void )
{

	// Uninitialize Process
	pVtxBuf->Release();
	RenderInterfaceManager::Delete( renderer );
	GameObjectManager::Release(this);

}

// MeshCube Update
void MeshCube::Update( void )
{

	// Update Process
	world.Identity();

}


// MeshCube SetBuffer
void MeshCube::SetBuffer( const Vector3& vec )
{

	// Vertual Pointer
	Vertex3D*       pVtx;

	Vector3 diagonal = -vec;
	//Vector3 start = Vector3( -vertical*size*0.5f, 0, horizonal*size*0.5f );

	{ // _obt@̐ݒ

		int index = 0;

		pVtxBuf->Lock( &pVtx );

		pVtx[ index++ ].pos    = D3DXVECTOR3( diagonal.x, vec.y, diagonal.z );
		pVtx[ index++ ].pos    = D3DXVECTOR3( diagonal.x, vec.y, vec.z );
		pVtx[ index++ ].pos    = D3DXVECTOR3( vec.x, vec.y, diagonal.z );
		pVtx[ index++ ].pos    = D3DXVECTOR3( vec.x, vec.y, diagonal.z );
		pVtx[ index++ ].pos    = D3DXVECTOR3( diagonal.x, vec.y, vec.z );
		pVtx[ index++ ].pos    = D3DXVECTOR3( vec.x, vec.y, vec.z );

		pVtx[ index++ ].pos    = D3DXVECTOR3( diagonal.x, diagonal.y, vec.z );
		pVtx[ index++ ].pos    = D3DXVECTOR3( diagonal.x, diagonal.y, diagonal.z );
		pVtx[ index++ ].pos    = D3DXVECTOR3( vec.x, diagonal.y, vec.z );
		pVtx[ index++ ].pos    = D3DXVECTOR3( vec.x, diagonal.y, vec.z );
		pVtx[ index++ ].pos    = D3DXVECTOR3( diagonal.x, diagonal.y, diagonal.z );
		pVtx[ index++ ].pos    = D3DXVECTOR3( vec.x, diagonal.y, diagonal.z );

		pVtx[ index++ ].pos    = D3DXVECTOR3( diagonal.x, diagonal.y, diagonal.z );
		pVtx[ index++ ].pos    = D3DXVECTOR3( diagonal.x, vec.y, diagonal.z );
		pVtx[ index++ ].pos    = D3DXVECTOR3( vec.x, diagonal.y, diagonal.z );
		pVtx[ index++ ].pos    = D3DXVECTOR3( vec.x, diagonal.y, diagonal.z );
		pVtx[ index++ ].pos    = D3DXVECTOR3( diagonal.x, vec.y, diagonal.z );
		pVtx[ index++ ].pos    = D3DXVECTOR3( vec.x, vec.y, diagonal.z );

		pVtx[ index++ ].pos    = D3DXVECTOR3( vec.x, diagonal.y, vec.z );
		pVtx[ index++ ].pos    = D3DXVECTOR3( vec.x, vec.y, vec.z );
		pVtx[ index++ ].pos    = D3DXVECTOR3( diagonal.x, diagonal.y, vec.z );
		pVtx[ index++ ].pos    = D3DXVECTOR3( diagonal.x, diagonal.y, vec.z );
		pVtx[ index++ ].pos    = D3DXVECTOR3( vec.x, vec.y, vec.z );
		pVtx[ index++ ].pos    = D3DXVECTOR3( diagonal.x, vec.y, vec.z );

		pVtx[ index++ ].pos    = D3DXVECTOR3( vec.x, vec.y, diagonal.z );
		pVtx[ index++ ].pos    = D3DXVECTOR3( vec.x, vec.y, vec.z );
		pVtx[ index++ ].pos    = D3DXVECTOR3( vec.x, diagonal.y, diagonal.z );
		pVtx[ index++ ].pos    = D3DXVECTOR3( vec.x, diagonal.y, diagonal.z );
		pVtx[ index++ ].pos    = D3DXVECTOR3( vec.x, vec.y, vec.z );
		pVtx[ index++ ].pos    = D3DXVECTOR3( vec.x, diagonal.y, vec.z );

		pVtx[ index++ ].pos    = D3DXVECTOR3( diagonal.x, diagonal.y, diagonal.z );
		pVtx[ index++ ].pos    = D3DXVECTOR3( diagonal.x, diagonal.y, vec.z );
		pVtx[ index++ ].pos    = D3DXVECTOR3( diagonal.x, vec.y, diagonal.z );
		pVtx[ index++ ].pos    = D3DXVECTOR3( diagonal.x, vec.y, diagonal.z );
		pVtx[ index++ ].pos    = D3DXVECTOR3( diagonal.x, diagonal.y, vec.z );
		pVtx[ index++ ].pos    = D3DXVECTOR3( diagonal.x, vec.y, vec.z );
		 
		index = 0;

		pVtx[ index++ ].nor = D3DXVECTOR3( 0.0f, 1.0f, 0.0f );
		pVtx[ index++ ].nor = D3DXVECTOR3( 0.0f, 1.0f, 0.0f );
		pVtx[ index++ ].nor = D3DXVECTOR3( 0.0f, 1.0f, 0.0f );
		pVtx[ index++ ].nor = D3DXVECTOR3( 0.0f, 1.0f, 0.0f );
		pVtx[ index++ ].nor = D3DXVECTOR3( 0.0f, 1.0f, 0.0f );
		pVtx[ index++ ].nor = D3DXVECTOR3( 0.0f, 1.0f, 0.0f );


		pVtx[ index++ ].nor = D3DXVECTOR3( 0.0f, -1.0f, 0.0f );
		pVtx[ index++ ].nor = D3DXVECTOR3( 0.0f, -1.0f, 0.0f );
		pVtx[ index++ ].nor = D3DXVECTOR3( 0.0f, -1.0f, 0.0f );
		pVtx[ index++ ].nor = D3DXVECTOR3( 0.0f, -1.0f, 0.0f );
		pVtx[ index++ ].nor = D3DXVECTOR3( 0.0f, -1.0f, 0.0f );
		pVtx[ index++ ].nor = D3DXVECTOR3( 0.0f, -1.0f, 0.0f );

		pVtx[ index++ ].nor = D3DXVECTOR3( 0.0f, 0.0f, -1.0f );
		pVtx[ index++ ].nor = D3DXVECTOR3( 0.0f, 0.0f, -1.0f );
		pVtx[ index++ ].nor = D3DXVECTOR3( 0.0f, 0.0f, -1.0f );
		pVtx[ index++ ].nor = D3DXVECTOR3( 0.0f, 0.0f, -1.0f );
		pVtx[ index++ ].nor = D3DXVECTOR3( 0.0f, 0.0f, -1.0f );
		pVtx[ index++ ].nor = D3DXVECTOR3( 0.0f, 0.0f, -1.0f );


		pVtx[ index++ ].nor = D3DXVECTOR3( 0.0f, 0.0f, 1.0f );
		pVtx[ index++ ].nor = D3DXVECTOR3( 0.0f, 0.0f, 1.0f );
		pVtx[ index++ ].nor = D3DXVECTOR3( 0.0f, 0.0f, 1.0f );
		pVtx[ index++ ].nor = D3DXVECTOR3( 0.0f, 0.0f, 1.0f );
		pVtx[ index++ ].nor = D3DXVECTOR3( 0.0f, 0.0f, 1.0f );
		pVtx[ index++ ].nor = D3DXVECTOR3( 0.0f, 0.0f, 1.0f );

		pVtx[ index++ ].nor = D3DXVECTOR3( 1.0f, 0.0f, 0.0f );
		pVtx[ index++ ].nor = D3DXVECTOR3( 1.0f, 0.0f, 0.0f );
		pVtx[ index++ ].nor = D3DXVECTOR3( 1.0f, 0.0f, 0.0f );
		pVtx[ index++ ].nor = D3DXVECTOR3( 1.0f, 0.0f, 0.0f );
		pVtx[ index++ ].nor = D3DXVECTOR3( 1.0f, 0.0f, 0.0f );
		pVtx[ index++ ].nor = D3DXVECTOR3( 1.0f, 0.0f, 0.0f );

		pVtx[ index++ ].nor = D3DXVECTOR3( -1.0f, 0.0f, 0.0f );
		pVtx[ index++ ].nor = D3DXVECTOR3( -1.0f, 0.0f, 0.0f );
		pVtx[ index++ ].nor = D3DXVECTOR3( -1.0f, 0.0f, 0.0f );
		pVtx[ index++ ].nor = D3DXVECTOR3( -1.0f, 0.0f, 0.0f );
		pVtx[ index++ ].nor = D3DXVECTOR3( -1.0f, 0.0f, 0.0f );
		pVtx[ index++ ].nor = D3DXVECTOR3( -1.0f, 0.0f, 0.0f );


		for( int index = 0; index < 6; index++ ){

			pVtx[ 0 + index*6 ].tex    = Vector2( 0.0f, 0.0f );
			pVtx[ 1 + index*6 ].tex    = Vector2( 1.0f, 0.0f );
			pVtx[ 2 + index*6 ].tex    = Vector2( 0.0f, 1.0f );
			pVtx[ 3 + index*6 ].tex    = Vector2( 0.0f, 1.0f );
			pVtx[ 4 + index*6 ].tex    = Vector2( 1.0f, 0.0f );
			pVtx[ 5 + index*6 ].tex    = Vector2( 1.0f, 1.0f );
		  	  				
			pVtx[ 0 + index*6 ].color  = color;
			pVtx[ 1 + index*6 ].color  = color;
			pVtx[ 2 + index*6 ].color  = color;
			pVtx[ 3 + index*6 ].color  = color;
			pVtx[ 4 + index*6 ].color  = color;
			pVtx[ 5 + index*6 ].color  = color;

		}


		pVtxBuf->Unlock( );

	} // -> END

}

// MeshCube Resize
void MeshCube::Resize( const int size, const int vertical, const int horizonal )
{

	// Reset Member Variable
	//MeshField::size = size;
	//MeshField::vertical  = vertical;
	//MeshField::horizonal = horizonal;

	// MeshField SetBuffer
	SetBuffer( Vector3(20,20,20) );
	 
}





