/***************************************************************/
//
//
//		DirectX	[ meshplane.cpp ]
//
//											Author	kazuki tanaka
//											Date	2017 6/19
/*---------------------------------------------------------------
Update : 2017/6/19
			meshplane.cpp̍쐬

/*---------------------------------------------------------------
	Include File
---------------------------------------------------------------*/

#include "meshplane.h"

#include "system_component.h"

#include "mesh_renderer.h"

#include "gameobject_manager.h"

#include "vertexbuffer_manager.h"
#include "texture_manager.h"

/*---------------------------------------------------------------
	Macro Difinition
---------------------------------------------------------------*/


/*----------------------------------------------------------------
	static member variable Initialize 
----------------------------------------------------------------*/





// MeshPlane Constructor
MeshPlane::MeshPlane( const std::string& filename, const float& vertical, const float& horizonal, const Color& color, const Vector3& pos, const Vector3& rot, const Vector3& scale, const Matrix& mat )
	: pVtxBuf(nullptr)
	, pTexture(nullptr)
	, pObject(nullptr)
	, color(color)
	, vertical(vertical)
	, horizonal(horizonal)
	, GameObject(pos,rot,scale,mat)
{

	// Member Clear Process
	pTexture = TextureManager::LoadFromManager( filename.data() );

}

// MeshPlane Destructor
MeshPlane::~MeshPlane( )
{

	// Do Nothing!!

}

// MeshPlane Create Instance 
MeshPlane* MeshPlane::Create( const std::string& filename, const float& vertical, const float& horizonal, const Color& color, const Vector3& pos, const Vector3& rot, const Vector3& scale, const Matrix& mat )
{

	// Create Class Instance
	return new MeshPlane(filename,vertical,horizonal,color,pos,rot,scale,mat);

}

// MeshPlane Initialize
void MeshPlane::Init( void )
{

	// Initialize Process
	world = world.Identity(); 

	pVtxBuf = VertexBufferManager::PlatformSelect();
	if( !pVtxBuf->CreateVertexBuffer( FVF_VERTEX_3D, 4 ) ) return;

	// Set Buffer < Vertex & Index >
	SetBuffer( );

	// Component Set
	pObject = MeshRenderer::SetComponent( &pVtxBuf, &pTexture, &world );

}

// MeshPlane Uninitialize
void MeshPlane::Uninit( void )
{

	// Uninitialize Process
	pVtxBuf->Release();
	RenderInterfaceManager::Delete( pObject );
	GameObjectManager::Release(this);

}

// MeshPlane Update
void MeshPlane::Update( void )
{

	// Update Process
	world = world.Identity();


}

// MeshPlane SetBuffer
void MeshPlane::SetBuffer( void )
{

	// Vertual Pointer
	Vertex3D*       pVtx;

	{ // _obt@̐ݒ

		pVtxBuf->Lock( &pVtx );

		pVtx[0].pos   = Vector3 ( -vertical*0.5f, horizonal*0.5f, 0.0f );									  
		pVtx[0].tex   = Vector2( 0.0f, 0.0f );			  
		pVtx[0].color = color;		
		pVtx[0].nor   = Vector3(0, 0, -1);

		pVtx[1].pos   = Vector3 ( vertical*0.5f, horizonal*0.5f, 0.0f );								  
		pVtx[1].tex   = Vector2( 1.0f, 0.0f );			  
		pVtx[1].color = color;			
		pVtx[1].nor   = Vector3(0, 0, -1);

		pVtx[2].pos   = Vector3 ( -vertical*0.5f, -horizonal*0.5f, 0.0f );									  
		pVtx[2].tex   = Vector2( 0.0f, 1.0f );			  
		pVtx[2].color = color;			
		pVtx[2].nor   = Vector3(0, 0, -1);

		pVtx[3].pos   = Vector3 ( vertical*0.5f, -horizonal*0.5f, 0.0f );							  
		pVtx[3].tex   = Vector2( 1.0f, 1.0f );			  
		pVtx[3].color = color;			
		pVtx[3].nor   = Vector3(0, 0, -1);

		pVtxBuf->Unlock( );

	} // -> END

}

// MeshPlane Resize
void MeshPlane::Resize( const float vertical, const float horizonal )
{

	// Reset Member Variable
	MeshPlane::vertical  = vertical;
	MeshPlane::horizonal = horizonal;

	// MeshPlane SetBuffer
	SetBuffer( );

}

// MeshPlane SetColor
void MeshPlane::SetColor( const Color& color )
{

	MeshPlane::color = color;

	SetBuffer( );

}

// MeshPlane ChangeTexture
void MeshPlane::ChangeTexture( const std::string& filename )
{
	
	pTexture = TextureManager::LoadFromManager(filename.data());
	
}

// MeshPlane Resize
void MeshPlane::Lock( Vertex3D* pVtx )
{

	pVtxBuf->Lock( &pVtx );

}
	
// MeshPlane Resize
void MeshPlane::Unlock( void )
{

	pVtxBuf->Unlock( );

}




