/***************************************************************/
//
//
//		DirectX	[ meshskydome.cpp ]
//
//											Author	kazuki tanaka
//											Date	2017 6/18
/*---------------------------------------------------------------
Update : 2017/6/18
			meshskydome.cpp̍쐬

/*---------------------------------------------------------------
	Include File
---------------------------------------------------------------*/


#include "meshskydome.h"

#include "mathematics.h"

#include "mesh_rendererex.h"

#include "vertexbuffer_manager.h"
#include "vertexbuffer.h"
#include "texture_manager.h"
#include "indexbuffer_manager.h"
#include "indexbuffer.h"

#include "d_console.h"


/*---------------------------------------------------------------
	Macro Difinition
---------------------------------------------------------------*/

#define Z_SDW_ROTATION ( 360 )
#define Y_SDW_ROTATION ( 90 )

using namespace Mathematics;

/*----------------------------------------------------------------
	static member variable Initialize 
----------------------------------------------------------------*/




// MeshSkydome Constructor
MeshSkydome::MeshSkydome( const std::string& filename )
	: pVtxBuf(nullptr)
	, pIdxBuf(nullptr)
	, pTexture(nullptr)
	, renderer(nullptr) 
	, world()
	, pos( Vector3(0,0,0) )
	, vertical(0)
	, horizonal(0)
	, radius(0)
	, theta(0)
	, phy(0)
{

	// Member Clear Process
	pTexture = TextureManager::LoadFromManager( filename.data() );

}

// MeshSkydome Destructor
MeshSkydome::~MeshSkydome( )
{

	// Do Nothing!!

}

// MeshSkydome Create Instance 
MeshSkydome* MeshSkydome::Create( void )
{

	// Create Class Instance
	return new MeshSkydome;

}

// MeshSkydome Initialize
void MeshSkydome::Init( void )
{

	// Initialize Process
	vertical  = 10;
	horizonal = 10;
	radius    = 500;

	pVtxBuf = VertexBufferManager::PlatformSelect( );
	pIdxBuf = IndexBufferManager::PlatformSelect( );

	if( !pVtxBuf->CreateVertexBuffer( FVF_VERTEX_3D, (( vertical*((vertical*4)+1) ) + 1 ) )) return;
	if( !pIdxBuf->CreateIndexBuffer( ((vertical)*(vertical*4+1) + (vertical-1)) *2 )) return;

	// Set Buffer < Vertex & Index >
	SetBuffer( );

	// Component Set
	renderer = MeshRendererEX::SetComponent( &pVtxBuf, &pIdxBuf, &pTexture, &world );


}

// MeshSkydome Uninitialize
void MeshSkydome::Uninit( void )
{

	// Uninitialize Process
	pVtxBuf->Release( );
	pIdxBuf->Release( );
	RenderInterfaceManager::Delete( renderer );

}

// MeshSkydome Update
void MeshSkydome::Update( void )
{

	// Update Process


}

// MeshSkydome SetBuffer
void MeshSkydome::SetBuffer( void )
{

	// Vertual Pointer
	Vertex3D*       pVtx;
	unsigned short* pIndex;

	{ // _obt@̐ݒ

		pVtxBuf->Lock( &pVtx );

		for( unsigned int y = 0,x = 0; y < vertical; y++ ){

			theta = (float)(Y_SDW_ROTATION/vertical) * y;

			for( x = 0; x < (vertical*4)+1 ; x++ ){

				phy = (float)(Z_SDW_ROTATION/((vertical*4))) * x;
		
				pVtx[ ((vertical*4)+1)*y + (x) + 0 ].pos    = Vector3(
					radius*sinf( ToRadian( 90-theta ))*cosf( ToRadian( phy )),
					radius*cosf( ToRadian( 90-theta )),
					radius*sinf( ToRadian( 90-theta ))*sinf( ToRadian( phy )) );
				pVtx[ ((vertical*4)+1)*y + (x) + 0 ].tex    = Vector2( (( 1.0f/(vertical*4)) * x), 1.0f-(( 1.0f/vertical) * y) );
				pVtx[ ((vertical*4)+1)*y + (x) + 0 ].color  = D3DCOLOR_RGBA(255,255,255,255);
				pVtx[ ((vertical*4)+1)*y + (x) + 0 ].nor = Vector3( 0.0f, 1.0f, 0.0f );

				//Console::DebugLog(" index : %d : coord : %f, %f \n", ((vertical*4)+1)*y + (x),  pVtx[ ((vertical*4)+1)*y + (x) + 0 ].tex.x, pVtx[ ((vertical*4)+1)*y + (x) + 0 ].tex.y );
			}
			if( y+1 == vertical ){

				x = 0;
				y++;

				theta = (float)(Y_SDW_ROTATION/vertical) * y+1;
				phy = 0;
		
				pVtx[ ((vertical*4)+1)*y + (x) + 0 ].pos    = Vector3(
					radius*sinf( ToRadian( 90-theta ))*cosf( ToRadian( phy )),
					radius*cosf( ToRadian( 90-theta )),
					radius*sinf( ToRadian( 90-theta ))*sinf( ToRadian( phy )) );
				pVtx[ ((vertical*4)+1)*y + (x) + 0 ].tex    = Vector2( 0.0f, 0.0f );//Vector2( (( 1.0f/(vertical*4+1)) * x), (( 1.0f/vertical) * y) );
				pVtx[ ((vertical*4)+1)*y + (x) + 0 ].color  = D3DCOLOR_RGBA( 255, 255, 255, 255 );
				pVtx[ ((vertical*4)+1)*y + (x) + 0 ].nor = Vector3( 0.0f, 1.0f, 0.0f );
				//Console::DebugLog(" index : %d : coord : %f, %f \n", ((vertical*4)+1)*y + (x),  pVtx[ ((vertical*4)+1)*y + (x) + 0 ].tex.x, pVtx[ ((vertical*4)+1)*y + (x) + 0 ].tex.y );
			}
		}

		pVtxBuf->Unlock( );

	} // -> END


	{ // _CfbNX̐ݒ

		pIdxBuf->Lock( &pIndex );

		for( unsigned int y = 0,x = 0,index = 0,alignNumber = 0,line = vertical*4+1; y < vertical; y++ ){

			// kރ|S̍쐬
			if( y ){
			
				x = 0;
				pIndex[ ((2)*line)*y + (2*x) + 0 + alignNumber*2 ] = pIndex[ ((2)*line)*y + (2*x) - 1 + alignNumber*2 ];
				pIndex[ ((2)*line)*y + (2*x) + 1 + alignNumber*2 ] = pIndex[ ((2)*line)*y + (2*x) - 1 + alignNumber*2 ] + (vertical*4)+2;
				alignNumber++;
			}

			for( x = 0; x < line; x++ ){

				pIndex[ ((2)*line)*y + (2*x) + 1 + alignNumber*2 ] = index;

				if( (y+1) == vertical ){
					pIndex[ ((2)*line)*y + (2*x) + 0 + alignNumber*2 ] = ( vertical*4+1 )*vertical;
				}else{
					pIndex[ ((2)*line)*y + (2*x) + 0 + alignNumber*2 ] = index + (vertical*4+1);
				}
				index++;
			
			}
		}

		pIdxBuf->Unlock( );

	} // -> END

}

// MeshSkydome Resize
void MeshSkydome::Resize( const float radius, const int vertical, const int horizonal )
{

	// Reset Member Variable
	MeshSkydome::radius = radius;
	MeshSkydome::vertical  = vertical;
	MeshSkydome::horizonal = horizonal;

	// MeshField SetBuffer
	SetBuffer( );

}





