/***************************************************************/
//
//
//		DirectX	[ model.h ]
//
//											Author	kazuki tanaka
//											Date	2017 6/7
/*---------------------------------------------------------------
Update : 2017/6/7
			Create Header File -> model.h.h 
 			< Add Class Function >
				MODEL->Constructor
				MODEL->Destructor
				MODEL->Create ( static member )
				MODEL->Init
				MODEL->Uninit
				MODEL->Update
				MODEL->Draw

Update : 2017/6/7



/*-------------------------------------------------------------*/
#ifndef _MODEL_H_

#define _MODEL_H_


/*---------------------------------------------------------------
	Include File
---------------------------------------------------------------*/

#include "gameobject.h"

class RenderInterface;
class ModelDX9Interface;

#include "mesh_renderer3d.h"
#include "model_manager.h"

/*---------------------------------------------------------------
	Class
---------------------------------------------------------------*/


// Class Model Using Model
class Model : public GameObject
{
public:

	Model( );							// Model Constructor
	~Model( );							// Model Destructor

	static Model* Create( 				// Model Create Instance Class
		const char* filename,
		const Vector3& pos,
		const Vector3& rot );

	// Model Create Instance 
	template<class X> static X* Instance( 
		const char* filename,
		const Vector3& pos = Vector3(0,0,0),
		const Vector3& rot = Vector3(0,0,0),
		const Vector3& scale = Vector3(1,1,1))
	{
		// Create Class Instance
		X* pObject;
		pObject = new X;
	
		pObject->pMesh = ModelManager::LoadFromManager( filename ); 
		pObject->pos = pos;
		pObject->rot = rot;
		pObject->scale = scale;

		return pObject;
	}

	void Init( void ) override;			// Model Initialize
	void Uninit( void ) override;		// Model Uninitialize
	void Update( void ) override;		// Model Update

	void OnContact( void ) override;	// Model OnContact

private:

	// Member Variable
	RenderInterface* renderer;
	ModelInterface*  pMesh;


};


#endif	//	_MODEL_H_


