/***************************************************************/
//
//
//		DirectX	[ modelmanager.cpp ]
//
//											Author	kazuki tanaka
//											Date	2017 6/9
/*---------------------------------------------------------------
Update : 2017/6/9
			modelmanager.cpp̍쐬

/*---------------------------------------------------------------
	Include File
---------------------------------------------------------------*/

#define _CRT_SECURE_NO_WARNINGS

#include "model_manager.h"

#include "modeldx9_interface.h"
//#include "modelgl_interface.h"

#include "renderer.h"
#include "game_manager.h"

/*---------------------------------------------------------------
	Macro Difinition
---------------------------------------------------------------*/


/*---------------------------------------------------------------
	Const Number Difinition
---------------------------------------------------------------*/


/*----------------------------------------------------------------
	static member variable Initialize 
----------------------------------------------------------------*/

Resource<ModelInterface*> ModelManager::resource;




// ModelManager Constructor
ModelManager::ModelManager( )
{

	// Menber Clear Process

}

// ModelManager Destructor
ModelManager::~ModelManager( )
{

	// Do Nothing!!

}

// ModelManager Create Instance 
ModelManager* ModelManager::Create( void )
{

	// Create Class Instance
	ModelManager* pObject;
	pObject = new ModelManager;

	return pObject;

}

// ModelManager LoadFromManager
ModelInterface* ModelManager::LoadFromManager( const char* FILE_NAME )
{

	ModelInterface* pObject = nullptr;
	if( !(pObject = Bind( FILE_NAME )) ){
		Load( FILE_NAME );
		pObject = Bind( FILE_NAME );
	}

	return pObject;
}

// ModelManager Directory Search
void ModelManager::SearchLoadDirectory( void )
{

	char path[256]    = {}; 

	// Get < Client Absolute Path >
	GetModuleFileName( NULL, path, MAX_PATH );

	// Synthesys Command Order
	char command[256] = {};
	char drive[256] = {};
	char dir[256] = {};
	char filename[256] = {};
	char extension[256] = {};
	char search[256] = {"data\\model"};

	_splitpath( path, drive, dir, filename, extension );

	sprintf( filename, "%s.txt", filename );

	// Create output file
	sprintf( command, "dir %s%s%s >> %s", drive, dir, search, filename );
	system( command );

	// File Process
	FILE* pfile;

	if( !(pfile = fopen( filename, "rt" )) ){
		fclose(pfile);
		//return nullptr;

	}else{

		// t@CTCY擾
		fseek( pfile, 0, SEEK_END );
		unsigned int size = ftell( pfile );						// t@CTCY擾
		fseek( pfile, 0, SEEK_SET );

		// obt@m
		char* buf = new char[ size ]; 

		// t@Cǂݍ
		fread( buf, size, 1, pfile );
		fclose(pfile);
		delete[] buf;
		//return buf;
	}


	// Delete output file
	sprintf( command, "del /q  %s", filename );
	system( command );


}

// ModelManager Load Texture
bool ModelManager::Load( const char* FILE_NAME )
{
	

	// Confirm Platform
	Renderer::TYPE type = GameManager::PlatformInfo( );
			
	switch( type ){
			
	case  Renderer::RENDERER_DX9:{
				
		ModelInterface* pModel = ModelDX9Interface::Create( );
		if( pModel->Load( FILE_NAME )){
			resource.Registry( FILE_NAME, pModel );
		}

		return true;
		}break;
										 
	case  Renderer::RENDERER_GL:{

		//data[index].texture
		/*
		ModelInterface* pModel = ModelGLInterface::Create( );
		if( pModel->Load( FILE_NAME ) ){
			resource.Registry( FILE_NAME, pModel );
		}
		*/

		return true;
		}break;

	default:
		break;
	}
	
	return false;
	
}

// ModelManager Bind Texture
ModelInterface* ModelManager::Bind( const char* FILE_NAME )
{
	
	// bind - Model Data
	return resource.Export(FILE_NAME);

}
 
// ModelManager UnloadAll
void ModelManager::UnloadAll( void )
{

	// resource data -> Release
	resource.Delete( );

}

// ModelManager Release
void ModelManager::Release( ModelInterface* data )
{

	resource.Release(data);
	SAFE_DELETE(data)

}

