/***************************************************************/
//
//
//		DirectX	[ modelmanager.h ]
//
//											Author	kazuki tanaka
//											Date	2017 6/9
/*---------------------------------------------------------------
Update : 2017/6/9
			Create Header File -> modelmanager.h.h 
 			< Add Class Function >
				MODELMANAGER->Constructor
				MODELMANAGER->Destructor
				MODELMANAGER->Create ( static member )
				MODELMANAGER->Init
				MODELMANAGER->Uninit
				MODELMANAGER->Update
				MODELMANAGER->Draw

Update : 2017/6/9



/*-------------------------------------------------------------*/
#ifndef _MODELMANAGER_H_

#define _MODELMANAGER_H_


/*---------------------------------------------------------------
	Include File
---------------------------------------------------------------*/

#include "model_interface.h"

#include "resource_data.h"


class TextureInterface;

/*---------------------------------------------------------------
	Class
---------------------------------------------------------------*/


// Class ModelManager Using ModelManager
class ModelManager
{
public:
	
	ModelManager( );							// ModelManager Constructor
	~ModelManager( );							// ModelManager Destructor

	static ModelManager* Create( void );		// ModelManager Create Instance Class

	static bool Load( const char* FILE_NAME );	// ModelManager File Load Process
	
	static ModelInterface* Bind(				// ModelManager Bind
		const char* FILE_NAME );

	static ModelInterface* LoadFromManager(		// ModelManager LoadFromManager
		const char* FILE_NAME );

	static void SearchLoadDirectory( void );	// ModelManager Directory Search

	static void UnloadAll( void );				// ModelManager UnloadAll

	static void Release(						// ModelManager Release
		ModelInterface* data );
	

private:

	// Member Variable
	static Resource<ModelInterface*> resource;


};


#endif	//	_MODELMANAGER_H_


