/***************************************************************/
//
//
//		DirectX	[ mouse.h ]
//
//											Author	kazuki tanaka
//											Date	2017 2/15
/*---------------------------------------------------------------
Update : 2017/2/15
			Create Header File -> mouse.h.h 
 			< Add Class Function >
				CMouse->Constructor
				CMouse->Destructor
				CMouse->Create ( static member )
				CMouse->Access ( static member )
				CMouse->Init
				CMouse->Uninit
				CMouse->Update
				CMouse->ReleaseAll ( static member )
				CMouse->UpdateAll  ( static member )
				CMouse->DrawAll    ( static member )

Update : 2017/2/15



/*-------------------------------------------------------------*/
#ifndef _MOUSE_H_

#define _MOUSE_H_


#include "input.h"

#include "vector2.h"

#define STRING_MAX    (16)						// Mouse Name char Max Number
#define MOUSE_MAX     ( 2)						// Mouse Instance Max Number 

#define MOUSE_BIT_MAX ( 8 )						// Max Key Number


/*---------------------------------------------------------------
	Class
---------------------------------------------------------------*/


// Class InputMouse Using Mouse
class InputMouse : public CInput
{
public:
	
	// Virtual Mouse Button
	typedef enum{
		MOUSE_BUTTON_LEFT = 0,					// MouseButtonLeft
		MOUSE_BUTTON_RIGHT,						// MouseButtonRight
		MOUSE_BUTTON_CENTER						// MouseButtonWheel
	}MOUSE_STATE;
	
	InputMouse( );								// InputMouse constructor
	~InputMouse( );								// InputMouse destructor

	static InputMouse* Create( void );			// InputMouse Create Instance Class
	static void ReleaseAll( void );				// InputMouse Class Release All
	static void UpdateAll( void );				// InputMouse Update Class All
	static InputMouse* Access(					// InputMouse Class Access Outside Function
		const int index = 0 );

	HRESULT Init(								// InputMouse Initialize
		HINSTANCE hInstance,
		HWND hWnd);
	virtual void Uninit( void );				// InputMouse Uninitialize
	virtual void Update( void );				// InputMouse Update
	
	bool GetPress( const int& key );			// InputMouse Press
	bool GetTrigger( const int& key );			// InputMouse Trigger
	bool GetRelease( const int& key );			// InputMouse Release
	void FlushKeyTrigger(int nKey);				// InputMouse KeyTrigger

	long GetAxisX(void);						// InputMouse MouseX
	long GetAxisY(void);						// InputMouse MouseY
	long GetAxisZ(void);						// InputMouse MouseZ

	const Vector2& GetPosWorld(void){return pos;}

private:

	// Mouse Member
	int           myNumber;						// ID
	
	DIMOUSESTATE2 state;						// state
	DIMOUSESTATE2 trigger;						// trigger
	DIMOUSESTATE2 release;						// release
	Vector2       pos;							// pos
	
	// static Member
	static InputMouse* pMouse[ MOUSE_MAX ];			// Mouse Instance


};


#endif	//	_MOUSE_H_


